using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.IO;

namespace SystemTray
{
	public partial class CopyForm : Form
	{
		private AbstractCopyFiles abstractCopyFiles;
		private Thread copyThread;
		
		public CopyForm(AbstractCopyFiles abstractCopyFiles)
		{
			this.abstractCopyFiles = abstractCopyFiles;
			copyThread = new Thread(new ThreadStart(RunCopy));
			copyThread.Name = "CopyFormTask";

			abstractCopyFiles.OnCopyFile += IncrementProgressBar;

			InitializeComponent();

			MinimumSize = Size;
			MaximumSize = Size;
			Text = abstractCopyFiles.TextInfo;
		}

		private void RunCopy()
		{
			try
			{
				abstractCopyFiles.Copy();
			}
			catch (ThreadAbortException)
			{

			}
			catch (Exception e)
			{
				MessageBox.Show(e.Message);
			}
			finally
			{
				BeginInvoke((MethodInvoker)delegate()
				{
					Close();
				});
			}
		}

		private void OnShown(object sender, EventArgs e)
		{
			progressBar.Minimum = 0;
			progressBar.Maximum = abstractCopyFiles.NumberOfFiles(); //TODO: this method should be called asynchronously -> freezes the progress bar form for a while.

			copyThread.Start();
		}

		private void IncrementProgressBar(FileInfo fileInfo)
		{
			BeginInvoke((MethodInvoker)delegate()
			{
				progressBar.Value++;
			});
		}

		private void buttonCancel_Click(object sender, EventArgs e)
		{
			copyThread.Abort();
			Visible = false;
		}
	}
}
