using System;
using System.IO;
using BuildTools;

namespace SystemTray
{
	class CopyPcBuild : AbstractCopyPcFiles
	{
		private DirectoryInfo source;
		private DirectoryInfo destination;
		private BuildInfo buildInfo;

		public CopyPcBuild(BuildInfo buildInfo, string destination)
		{
			source = new DirectoryInfo(buildInfo.FullPath);
			if (!source.Exists)
				throw new Exception(string.Format("CopyDirectoryTask: Source directory not found [{0}]", buildInfo.FullPath));

			this.destination = new DirectoryInfo(destination);

			this.buildInfo = buildInfo;
		}

		override public int NumberOfFiles()
		{
			return NumberOfFiles(source);
		}

		override public void Copy()
		{
			Copy(source, destination);
		}

		public override string TextInfo
		{
			get { return string.Format("Copy Pc Build [{0}]", buildInfo.Number); }
		}
	}
}

