using System;
using System.IO;
using System.Collections.Generic;
using BuildTools;

namespace SystemTray
{

	class CopyPcData : AbstractCopyPcFiles
	{
		private string destination;
		private GameDataCollection gameDataCollection;

		public CopyPcData(BuildInfo buildInfo, string destination)
		{
			this.destination = destination;
			this.gameDataCollection = new GameDataCollection(buildInfo);

			this.gameDataCollection.AddGamesFolder();
			this.gameDataCollection.AddDirectory("Editor");
			this.gameDataCollection.AddDirectory("USER");
			this.gameDataCollection.AddFile("system.cfg");
		}

		override public int NumberOfFiles()
		{
			int res = 0;

			foreach (DirectoryInfo directoryInfo in gameDataCollection.SourceDirectories)
				res += NumberOfFiles(directoryInfo);

			foreach (FileInfo fileInfo in gameDataCollection.SourceFiles)
				res++;
			
			return res;
		}

		override public void Copy()
		{
			foreach (DirectoryInfo directoryInfo in gameDataCollection.SourceDirectories)
			{
				string destination = Path.Combine(this.destination, directoryInfo.Name);
				Copy(directoryInfo, new DirectoryInfo(destination));
			}

			foreach (FileInfo fileInfo in gameDataCollection.SourceFiles)
			{
				string destination = Path.Combine(this.destination, fileInfo.Name);
				Copy(fileInfo, destination);
			}
		}

		public override string TextInfo
		{
			get { return string.Format("Copy Pc Data [{0}]", gameDataCollection.BuildInfo.Number); }
		}
	}
}
