using System;
using System.IO;
using BuildTools;

namespace SystemTray
{
	class CopyXBox360Build : AbstractCopyXbox360Files
	{
		DirectoryInfo source;
		BuildInfo buildInfo;

		public CopyXBox360Build(BuildInfo buildInfo, bool useDefault, string address)
			:	base(useDefault, address)
		{
			this.source = new DirectoryInfo(buildInfo.FullPath);
			this.buildInfo = buildInfo;
		}

		public override int NumberOfFiles()
		{
			return NumberOfFiles(source);
		}

		public override void Copy()
		{
			Copy("xE:\\", source);
		}

		public override string TextInfo
		{
			get { return string.Format("Copy XBox360 Build [{0}]", buildInfo.Number); }
		}
	}
}
