using System.IO;
using BuildTools;

namespace SystemTray
{
	class CopyXbox360Data : AbstractCopyXbox360Files
	{
		private DirectoryInfo source;
		private string destination;
		private GameDataCollection gameDataCollection;

		public CopyXbox360Data(BuildInfo buildInfo, string destination, bool useDefault, string address)
			:	base(useDefault, address)
		{
			this.source = new DirectoryInfo(buildInfo.FullPath);
			this.destination = "xE:\\" + destination;
			this.gameDataCollection = new GameDataCollection(buildInfo);

			this.gameDataCollection.AddGamesFolder();
			this.gameDataCollection.AddDirectory("USER");
			this.gameDataCollection.AddFile("system.cfg");
		}

		public override int NumberOfFiles()
		{
			int res = 0;

			foreach (DirectoryInfo directoryInfo in gameDataCollection.SourceDirectories)
				res += NumberOfFiles(directoryInfo);

			foreach (FileInfo fileInfo in gameDataCollection.SourceFiles)
				res++;

			return res;
		}

		public override void Copy()
		{
			CreateDirectory(destination);
			Copy(destination);
		}

		private void Copy(string destination)
		{
			foreach (DirectoryInfo directoryInfo in gameDataCollection.SourceDirectories)
			{
				Copy(destination, directoryInfo);
			}

			foreach (FileInfo fileInfo in gameDataCollection.SourceFiles)
			{
				Copy(destination, fileInfo);
			}
		}

		public override string TextInfo
		{
			get { return string.Format("Copy Xbox360 Data [{0}]", gameDataCollection.BuildInfo.Number); }
		}
	}
}
