using System.IO;
using System.Collections.Generic;
using BuildTools;

namespace SystemTray
{
	class GameDataCollection
	{
		private BuildInfo buildInfo;
		private ICollection<DirectoryInfo> sourceDirectories;
		private ICollection<FileInfo> sourceFiles;

		public GameDataCollection(BuildInfo buildInfo)
		{
			this.buildInfo = buildInfo;
			sourceDirectories = new List<DirectoryInfo>();
			sourceFiles = new List<FileInfo>();
		}

		public void AddGamesFolder()
		{
			DirectoryInfo mainBuildDir = new DirectoryInfo(buildInfo.FullPath);
			foreach (DirectoryInfo gameBuildDir in mainBuildDir.GetDirectories("Game*"))
				sourceDirectories.Add(gameBuildDir);
		}

		public void AddDirectory(string directoryName)
		{
			DirectoryInfo directory = new DirectoryInfo(Path.Combine(buildInfo.FullPath, directoryName));
			if (directory.Exists)
				sourceDirectories.Add(directory);
		}

		public void AddFile(string fileName)
		{
			FileInfo file = new FileInfo(Path.Combine(buildInfo.FullPath, fileName));
			if (file.Exists)
				sourceFiles.Add(file);
		}

		public ICollection<DirectoryInfo> SourceDirectories
		{
			get { return sourceDirectories; }
		}

		public ICollection<FileInfo> SourceFiles
		{
			get { return sourceFiles; }
		}

		public BuildInfo BuildInfo
		{
			get { return buildInfo; }
		}
	}
}
