using System;
using System.IO;
using System.Collections.Generic;
using BuildTools;

namespace SystemTray
{
	public class LevelInfo
	{
		private RunLastPcBuild m_runLastPcBuild;
		private BuildInfo m_buildInfo;
		private ICollection<string> m_levels;

		public LevelInfo(string buildsFolder, string projectName, string execFile, string arguments)
		{
			m_runLastPcBuild = new RunLastPcBuild(buildsFolder, projectName, execFile, arguments);
			m_buildInfo = null;
			m_levels = new List<string>();
		}

		private void PopulateLevels()
		{
			DirectoryInfo levelsDirectory = new DirectoryInfo(Path.Combine(m_buildInfo.FullPath, @"Game\Levels"));
			if (levelsDirectory.Exists)
			{
				foreach (DirectoryInfo level in levelsDirectory.GetDirectories())
				{
					string levelName = level.Name;
					if (!levelName.StartsWith("!"))
					{
						m_levels.Add(levelName);
					}
				}
			}
		}

		public bool Load()
		{
			m_buildInfo = m_runLastPcBuild.Find();

			if (m_buildInfo == null)
				return false;

			PopulateLevels();

			return true;
		}

		public ICollection<string> Levels
		{
			get { return m_levels; }
		}

		public void Run(string levelName)
		{
			string loadLevel = string.Format("+map {0}", levelName);
			m_runLastPcBuild.Run(m_buildInfo, loadLevel);
		}
	}
}
