using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SystemTray
{
	public partial class PlayLevelForm : Form
	{
		private static bool g_isRunning = false;
		private LevelInfo m_levelInfo;

		public PlayLevelForm(LevelInfo levelInfo)
		{
			m_levelInfo = levelInfo;
			InitializeComponent();

			MinimumSize = Size;
			MaximumSize = Size;

			foreach (string level in levelInfo.Levels)
				m_levelsComboBox.Items.Add(level);

			IEnumerator first = m_levelsComboBox.Items.GetEnumerator();
			if (first.MoveNext())
				m_levelsComboBox.SelectedItem = first.Current;
		}

		public static bool IsRunning()
		{
			return g_isRunning;
		}

		private void m_buttonCancel_Click(object sender, EventArgs e)
		{
			Close();
		}

		private void m_buttonOK_Click(object sender, EventArgs e)
		{
			string level = m_levelsComboBox.SelectedItem.ToString();
			if (level.Length == 0)
			{
				MessageBox.Show("Please select a level");
			}
			else
			{
				try
				{
					m_levelInfo.Run(level);
				}
				catch (Exception exception)
				{
					MessageBox.Show(exception.Message);
				}
			}

			Close();
		}

		private void PlayLevelForm_Shown(object sender, EventArgs e)
		{
			g_isRunning = true;
		}

		private void PlayLevelForm_FormClosed(object sender, FormClosedEventArgs e)
		{
			g_isRunning = false;
		}
	}
}