using System;
using System.IO;
using System.Diagnostics;
using BuildTools;

namespace SystemTray
{
	class RunLastPcBuild
	{
		private string m_buildsFolder;
		private string m_projectName;
		private string m_execFile;
		private string m_arguments;

		public RunLastPcBuild(string buildsFolder, string projectName, string execFile, string arguments)
		{
			m_buildsFolder = buildsFolder;
			m_projectName = projectName;
			m_execFile = execFile;
			m_arguments = arguments;
		}

		public BuildInfo Find()
		{
			BuildInfo res = null;
			if (Directory.Exists(m_buildsFolder))
			{
				try
				{
					BuildInfoList buildInfoList = BuildInfoList.CreateWithCustomFolderStructure(m_buildsFolder, m_projectName, Platform.Pc);
					buildInfoList.Update();
					res = buildInfoList.GetLastVersion();
				}
				catch (Exception) {}
			}
			return res;
		}

		public void Run(BuildInfo buildInfo, params string[] extraArgs)
		{
			string arguments = m_arguments;
			foreach (string arg in extraArgs)
			{
				arguments += " ";
				arguments += arg;
			}
			string exe = Path.Combine(buildInfo.FullPath, m_execFile);
			Process.Start(exe, arguments);
		}
	}
}
