using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;

namespace SystemTray
{
	class Settings
	{
		private Configuration _configuration;
		private KeyValueConfigurationCollection _appSettings;

		private const string BUILDS_FOLDER = "buildsFolder";
		private const string PROJECT = "project";
		private const string TIME_PERIOD = "timePeriod";
		private const string XBOX_AUTOCOPY = "xboxAutoCopy";
		private const string XBOX_AUTOCOPY_DATA = "xboxAutoCopyData";
		private const string XBOX_ADDRESS = "xboxAddress";
		private const string XBOX_USE_DEFAULT = "xboxUseDefault";
		private const string PC_AUTOCOPY = "pcAutoCopy";
		private const string PC_AUTOCOPY_DATA = "pcAutoCopyData";
		private const string PC_DEST_FOLDER = "pcDestFolder";
		private const string PC_LATEST_DATA_DEST_FOLDER = "pcLatestDataDestFolder";
		private const string XBOX_LATEST_DATA_DEST_FOLDER = "xboxLatestDataDestFolder";
		private const string DISABLE_NOTIFIER = "disableNotifier";
		private const string PC_EXEC_FILE_GAME = "pcExecFileGame";
		private const string PC_EXEC_FILE_EDITOR = "pcExecFileEditor";
		private const string PC_EXEC_FILE_GAME_ARGUMENTS = "pcExecFileGameArguments";
		private const string PC_EXEC_FILE_EDITOR_ARGUMENTS = "pcExecFileEditorArguments";

		private string m_buildsFolder;
		private string m_project;
		private bool m_disableNotifier;
		private	int m_timePeriod;
		private bool m_xboxAutoCopy;
		private bool m_xboxAutoCopyData;
		private string m_xboxAddress;
		private bool m_xboxUseDefault;
		private bool m_pcAutoCopy;
		private bool m_pcAutoCopyData;
		private string m_pcDestFolder;
		private string m_pcLatestDataDestFolder;
		private string m_xboxLatestDataDestFolder;
		private string m_pcExecFileGame;
		private string m_pcExecFileEditor;
		private string m_pcExecFileGameArguments;
		private string m_pcExecFileEditorArguments;

		public Settings()
		{
			_configuration = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
			_appSettings = _configuration.AppSettings.Settings;

			m_buildsFolder = ReadVariable(BUILDS_FOLDER, @"\\storage\Builds\builds");
			m_project = ReadVariable(PROJECT, "crysis2");
			m_disableNotifier = ReadVariable(DISABLE_NOTIFIER, false);
			m_timePeriod = ReadVariable(TIME_PERIOD, 30000);

			m_xboxAutoCopy = ReadVariable(XBOX_AUTOCOPY, false);
			m_xboxAutoCopyData = ReadVariable(XBOX_AUTOCOPY_DATA, false);
			m_xboxAddress = ReadVariable(XBOX_ADDRESS, "");
			m_xboxUseDefault = ReadVariable(XBOX_USE_DEFAULT, true);
			m_xboxLatestDataDestFolder = ReadVariable(XBOX_LATEST_DATA_DEST_FOLDER, "Game03");

			m_pcDestFolder = ReadVariable(PC_DEST_FOLDER, @"E:\builds");
			m_pcAutoCopy = ReadVariable(PC_AUTOCOPY, false);
			m_pcAutoCopyData = ReadVariable(PC_AUTOCOPY_DATA, false);
			m_pcLatestDataDestFolder = ReadVariable(PC_LATEST_DATA_DEST_FOLDER, @"E:\dev\crysis2");

			m_pcExecFileGame = ReadVariable(PC_EXEC_FILE_GAME, @"Bin32\Crysis.exe");
			m_pcExecFileEditor = ReadVariable(PC_EXEC_FILE_EDITOR, @"Bin32\Editor.exe");
			m_pcExecFileGameArguments = ReadVariable(PC_EXEC_FILE_GAME_ARGUMENTS, "-dx9");
			m_pcExecFileEditorArguments = ReadVariable(PC_EXEC_FILE_EDITOR_ARGUMENTS, "-dx9");
		}

		private string ReadVariable(string variableName, string defaultValue)
		{
			string res = defaultValue;
			KeyValueConfigurationElement keyValue = _appSettings[variableName];
			if (keyValue != null)
				res = keyValue.Value;
			return res;
		}

		private int ReadVariable(string variableName, int defaultValue)
		{
			int res = defaultValue;
			KeyValueConfigurationElement keyValue = _appSettings[variableName];
			if (keyValue != null)
			{
				try
				{
					res = Int32.Parse(keyValue.Value);
				}
				catch (Exception) {}	
			}
			return res;
		}

		private bool ReadVariable(string variableName, bool defaultValue)
		{
			bool res = defaultValue;
			KeyValueConfigurationElement keyValue = _appSettings[variableName];
			if (keyValue != null)
			{
				try
				{
					res = bool.Parse(keyValue.Value);
				}
				catch (Exception) { }
			}
			return res;
		}

		public override int GetHashCode()
		{
			return base.GetHashCode();
		}

		public override bool Equals(object obj)
		{
			if (typeof(Settings) != obj.GetType())
				return false;

			Settings settings = (Settings)obj;

			return (m_buildsFolder.Equals(settings.m_buildsFolder) &&
					m_project.Equals(settings.m_project) &&
					m_disableNotifier == settings.m_disableNotifier &&
					m_timePeriod == settings.m_timePeriod &&
					m_xboxAutoCopy == settings.m_xboxAutoCopy &&
					m_xboxAutoCopyData == settings.m_xboxAutoCopyData &&
					m_xboxAddress.Equals(settings.m_xboxAddress) &&
					m_xboxUseDefault == settings.m_xboxUseDefault &&
					m_pcAutoCopy == settings.m_pcAutoCopy &&
					m_pcAutoCopyData == settings.m_pcAutoCopyData &&
					m_pcDestFolder.Equals(settings.m_pcDestFolder) &&
					m_pcLatestDataDestFolder.Equals(settings.m_pcLatestDataDestFolder) &&
					m_xboxLatestDataDestFolder.Equals(settings.m_xboxLatestDataDestFolder) &&
					m_pcExecFileGame.Equals(settings.m_pcExecFileGame) &&
					m_pcExecFileEditor.Equals(settings.m_pcExecFileEditor) &&
					m_pcExecFileGameArguments.Equals(settings.m_pcExecFileGameArguments) &&
					m_pcExecFileEditorArguments.Equals(settings.m_pcExecFileEditorArguments));
		}

		public void Save()
		{
			SetValue(BUILDS_FOLDER, m_buildsFolder);
			SetValue(PROJECT, m_project);
			SetValue(DISABLE_NOTIFIER, m_disableNotifier);
			SetValue(TIME_PERIOD, m_timePeriod);

			SetValue(XBOX_ADDRESS, m_xboxAddress);
			SetValue(XBOX_USE_DEFAULT, m_xboxUseDefault);
			SetValue(XBOX_AUTOCOPY, m_xboxAutoCopy);
			SetValue(XBOX_AUTOCOPY_DATA, m_xboxAutoCopyData);
			SetValue(XBOX_LATEST_DATA_DEST_FOLDER, m_xboxLatestDataDestFolder);

			SetValue(PC_AUTOCOPY, m_pcAutoCopy);
			SetValue(PC_AUTOCOPY_DATA, m_pcAutoCopyData);
			SetValue(PC_DEST_FOLDER, m_pcDestFolder);
			SetValue(PC_LATEST_DATA_DEST_FOLDER, m_pcLatestDataDestFolder);

			SetValue(PC_EXEC_FILE_GAME, m_pcExecFileGame);
			SetValue(PC_EXEC_FILE_EDITOR, m_pcExecFileEditor);
			SetValue(PC_EXEC_FILE_GAME_ARGUMENTS, m_pcExecFileGameArguments);
			SetValue(PC_EXEC_FILE_EDITOR_ARGUMENTS, m_pcExecFileEditorArguments);

            _configuration.Save();
		}

		private void SetValue(string key, object value)
		{
			KeyValueConfigurationElement keyValue = _appSettings[key];
			if (keyValue != null)
			{
				keyValue.Value = value.ToString();
			}
			else
			{
				_appSettings.Add(key, value.ToString());
			}
		}

		public string BuildsFolder
		{
			get { return m_buildsFolder; }
			set { m_buildsFolder = value; }
		}

		public string Project
		{
			get { return m_project; }
			set { m_project = value; }
		}

		public bool DisableNotifier
		{
			get { return m_disableNotifier; }
		}

		public int TimePeriod
		{
			get { return m_timePeriod; }
		}

		public bool XboxAutoCopy
		{
			get { return m_xboxAutoCopy; }
			set { m_xboxAutoCopy = value; }
		}

		public bool XboxAutoCopyData
		{
			get { return m_xboxAutoCopyData; }
			set { m_xboxAutoCopyData = value; }
		}

		public string XboxAddress
		{
			get { return m_xboxAddress; }
			set { m_xboxAddress = value; }
		}

		public bool XboxUseDefault
		{
			get { return m_xboxUseDefault; }
			set { m_xboxUseDefault = value; }
		}

		public bool PcAutoCopy
		{
			get { return m_pcAutoCopy; }
			set { m_pcAutoCopy = value; }
		}

		public bool PcAutoCopyData
		{
			get { return m_pcAutoCopyData; }
			set { m_pcAutoCopyData = value; }
		}

		public string PcDestFolder
		{
			get { return m_pcDestFolder; }
			set { m_pcDestFolder = value; }
		}

		public string PcLatestDataDestFolder
		{
			get { return m_pcLatestDataDestFolder; }
			set { m_pcLatestDataDestFolder = value; }
		}

		public string XboxLatestDataDestFolder
		{
			get { return m_xboxLatestDataDestFolder; }
			set { m_xboxLatestDataDestFolder = value; }
		}

		public string PcExecFileGame
		{
			get { return m_pcExecFileGame;  }
		}

		public string PcExecFileEditor
		{
			get { return m_pcExecFileEditor; }
		}

		public string PcExecFileGameArguments
		{
			get { return m_pcExecFileGameArguments; }
		}

		public string PcExecFileEditorArguments
		{
			get { return m_pcExecFileEditorArguments; }
		}
	}
}
