using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SystemTray
{
	partial class SettingsForm : Form
	{
		public SettingsForm()
		{
			InitializeComponent();

			Settings settings = new Settings();

			_storageFolderTextBox.Text = settings.BuildsFolder;
			_projectNameTextBox.Text = settings.Project;

			_xboxUseDefault.Checked = settings.XboxUseDefault;
			_xboxAddress.Text = settings.XboxAddress;
			_xboxAutoCopyEnabled.Checked = settings.XboxAutoCopy;
			_xboxAutoCopyDataEnabled.Checked = settings.XboxAutoCopyData;

			_pcDestFolder.Text = settings.PcDestFolder;
			_pcAutocopyEnabled.Checked = settings.PcAutoCopy;
			_pcAutocopyDataEnabled.Checked = settings.PcAutoCopyData;

			_pcLatestDataDest.Text = settings.PcLatestDataDestFolder;
			_xboxLatestDataDest.Text = settings.XboxLatestDataDestFolder;

			UpdateXboxUseDefault();
		}

		private void UpdateXboxUseDefault()
		{
			_xboxAddress.Enabled = !_xboxUseDefault.Checked;
		}

		private void _okButton_Click(object sender, EventArgs e)
		{
			DialogResult = DialogResult.OK;
			Close();
		}

		private void _cancelButton_Click(object sender, EventArgs e)
		{
			DialogResult = DialogResult.Cancel;
			Close();
		}

		private void _xboxUseDefault_CheckedChanged(object sender, EventArgs e)
		{
			UpdateXboxUseDefault();
		}

		public Settings Settings
		{
			get
			{ 
				Settings settings = new Settings();

				settings.BuildsFolder = _storageFolderTextBox.Text;
				settings.Project = _projectNameTextBox.Text;

				settings.XboxUseDefault = _xboxUseDefault.Checked;
				settings.XboxAddress = _xboxAddress.Text;
				settings.XboxAutoCopy = _xboxAutoCopyEnabled.Checked;
				settings.XboxAutoCopyData = _xboxAutoCopyDataEnabled.Checked;
				settings.XboxLatestDataDestFolder = _xboxLatestDataDest.Text;

				settings.PcAutoCopy = _pcAutocopyEnabled.Checked;
				settings.PcAutoCopyData = _pcAutocopyDataEnabled.Checked;
				settings.PcDestFolder = _pcDestFolder.Text;
				settings.PcLatestDataDestFolder = _pcLatestDataDest.Text;

				return settings;
			}
		}

		private void _chooseStorageFolderButton_Click(object sender, EventArgs e)
		{
			FolderBrowserDialog folderBrowseDialog = new FolderBrowserDialog();
			if (DialogResult.OK == folderBrowseDialog.ShowDialog())
				_storageFolderTextBox.Text = folderBrowseDialog.SelectedPath;
		}

		private void button1_Click(object sender, EventArgs e)
		{
			FolderBrowserDialog folderBrowseDialog = new FolderBrowserDialog();
			if (DialogResult.OK == folderBrowseDialog.ShowDialog())
				_pcDestFolder.Text = folderBrowseDialog.SelectedPath;
		}

		private void _pcLatestDataSelectFolderButton_Click(object sender, EventArgs e)
		{
			FolderBrowserDialog folderBrowseDialog = new FolderBrowserDialog();
			if (DialogResult.OK == folderBrowseDialog.ShowDialog())
				_pcLatestDataDest.Text = folderBrowseDialog.SelectedPath;
		}
	}
}