﻿using System;
using System.Collections.Generic;
using System.Text;
using BuildTools;

namespace SystemTray
{
	class Xbox360BuildInfoList : BaseBuildInfoList
	{
		private static string baseFolder = @"E:\";

		private DebugMonitor.Connection connection;

		private Xbox360BuildInfoList(string project, Platform platform)
			: base(project, platform)
		{
			 connection = new DebugMonitor.Connection();
		}

		private Xbox360BuildInfoList(string project, Platform platform, string xboxName)
			: base(project, platform)
		{
			connection = new DebugMonitor.Connection(xboxName);
		}

		public void Update()
		{
			if (connection.ConnectionEsablished())
			{
				OnUpdateStart();

				DebugMonitor.WalkDirectory walkDirectory = new DebugMonitor.WalkDirectory(baseFolder);
				foreach (DebugMonitor.FileAttribute fileAttribute in walkDirectory)
				{
					if (fileAttribute.IsDirectory)
						OnUpdateDirectory(fileAttribute.Name, baseFolder + fileAttribute.Name);
				}

				OnUpdateDone();
			}
		}
	}
}
