using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using BuildTools;

namespace UnitTest
{
	[TestFixture]
	public class BuildInfoTest
	{
		[Test]
		public void CompareToLess()
		{
			BuildInfo buildInfo1 = new BuildInfo(1, Platform.Pc, DateTime.Today, "");
			BuildInfo buildInfo2 = new BuildInfo(2, Platform.Pc, DateTime.Today, "");

			Assert.AreEqual(-1, buildInfo1.CompareTo(buildInfo2));
		}

		[Test]
		public void CompareToMore()
		{
			BuildInfo buildInfo1 = new BuildInfo(1, Platform.Pc, DateTime.Today, "");
			BuildInfo buildInfo2 = new BuildInfo(2, Platform.Pc, DateTime.Today, "");

			Assert.AreEqual(1, buildInfo2.CompareTo(buildInfo1));
		}

		[Test]
		public void CompareToEqual()
		{
			BuildInfo buildInfo1 = new BuildInfo(1, Platform.Pc, DateTime.Today, "");
			BuildInfo buildInfo1again = new BuildInfo(1, Platform.Pc, DateTime.Today, "");

			Assert.AreEqual(0, buildInfo1.CompareTo(buildInfo1again));
		}

		[Test]
		public void DirectoryName()
		{
			BuildInfo buildInfo = new BuildInfo(1, Platform.Pc, DateTime.Today, @"MyDir\MyFolder");

			Assert.AreEqual("MyFolder", buildInfo.DirectoryName);
		}
	}
}
