using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using BuildTools;

namespace UnitTest
{
	[TestFixture]
	public class CmdLineArgsBuilderTest
	{
		[Test]
		public void SingleArgToRC()
		{
			CmdLineArgFlag cmdLineArg = new CmdLineArgFlag("VarName");

			Assert.AreEqual("/VarName", cmdLineArg.ToRC());
		}

		[Test]
		public void ValuedArgToRC()
		{
			CmdLineArgValue cmdLineArg = new CmdLineArgValue("VarName", "Value");

			Assert.AreEqual("/VarName=Value", cmdLineArg.ToRC());
		}

		[Test]
		public void SingleAndValuedArgValueToRC()
		{
			CmdLineArgsBuilder cmdLineArgs = new CmdLineArgsBuilder();
			cmdLineArgs.AppendFlag("VarName1");
			cmdLineArgs.AppendFlag("VarName2", "Value");

			Assert.AreEqual("/VarName1 /VarName2=Value ", cmdLineArgs.ToRC());
		}

		[Test]
		public void SingleArgToWin()
		{
			CmdLineArgFlag cmdLineArg = new CmdLineArgFlag("VarName");

			Assert.AreEqual("/VarName", cmdLineArg.ToWin());
		}

		[Test]
		public void ValuedArgToWin()
		{
			CmdLineArgValue cmdLineArg = new CmdLineArgValue("VarName", "Value");

			Assert.AreEqual("/VarName:Value", cmdLineArg.ToWin());
		}

		[Test]
		public void ArgElem()
		{
			CmdLineArg cmdLineArg = new CmdLineArg("Arg");

			Assert.AreEqual("Arg", cmdLineArg.ToWin());
			Assert.AreEqual("Arg", cmdLineArg.ToRC());
		}

		[Test]
		public void SingleAndValuedArgValueToWin()
		{
			CmdLineArgsBuilder cmdLineArgs = new CmdLineArgsBuilder();
			cmdLineArgs.AppendFlag("VarName1");
			cmdLineArgs.AppendFlag("VarName2", "Value");

			Assert.AreEqual("/VarName1 /VarName2:Value ", cmdLineArgs.ToWin());
		}

		[Test]
		public void SingleAndValuedArgValueToWinWithRawElem()
		{
			CmdLineArgsBuilder cmdLineArgs = new CmdLineArgsBuilder();
			cmdLineArgs.AppendFlag("VarName1");
			cmdLineArgs.Append("FreeElem");
			cmdLineArgs.AppendFlag("VarName2", "Value");

			Assert.AreEqual("/VarName1 FreeElem /VarName2:Value ", cmdLineArgs.ToWin());
		}

		[Test]
		public void SingleAndValuedArgValueToRCWithRawElem()
		{
			CmdLineArgsBuilder cmdLineArgs = new CmdLineArgsBuilder();
			cmdLineArgs.AppendFlag("VarName1");
			cmdLineArgs.Append("FreeElem");
			cmdLineArgs.AppendFlag("VarName2", "Value");

			Assert.AreEqual("/VarName1 FreeElem /VarName2=Value ", cmdLineArgs.ToRC());
		}
	}
}

