using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using BuildTools;

namespace UnitTest
{
	[TestFixture]
	public class FindBuidlTest
	{
		private Config _config;

		public FindBuidlTest()
		{
			_config = new Config();
		}

		private BuildInfo GetVersion(ICollection<BuildInfo> buildInfoList, int version)
		{
			foreach (BuildInfo buildInfo in buildInfoList)
			{
				if (buildInfo.Number == version)
					return buildInfo;
			}

			return null;
		}

		private FindBuild CreateFindBuild()
		{
			return CreateFindBuild(Platform.Pc);
		}

		private FindBuild CreateFindBuild(Platform platform)
		{
			BuildInfoList buildInfoList = new BuildInfoList(_config.Storage, _config.Game, platform);
			buildInfoList.Update();
			return new FindBuild(buildInfoList);
		}

		[Test]
		public void GetVersionsByDateEmpty()
		{
			FindBuild findBuild = CreateFindBuild();
			IList<BuildInfo> versions = findBuild.GetVersions(new DateTime(2008, 11, 5));

			Assert.AreEqual(0, versions.Count);
		}

		[Test]
		public void GetVersionsByDate()
		{
			FindBuild findBuild = CreateFindBuild();
			IList<BuildInfo> versions = findBuild.GetVersions(new DateTime(2008, 11, 8));

			Assert.AreEqual(4, versions.Count);
			Assert.IsNotNull(GetVersion(versions, 2));
			Assert.IsNotNull(GetVersion(versions, 5));
			Assert.IsNotNull(GetVersion(versions, 6));
			Assert.IsNotNull(GetVersion(versions, 7));
		}

		[Test]
		public void GetVersionsByDateXbox360()
		{
			FindBuild findBuild = CreateFindBuild(Platform.Xbox360);
			IList<BuildInfo> versions = findBuild.GetVersions(new DateTime(2008, 11, 7));

			Assert.AreEqual(1, versions.Count);
			Assert.IsNotNull(GetVersion(versions, 3));
		}

		[Test]
		public void GetVersionsByDatePS3()
		{
			FindBuild findBuild = CreateFindBuild(Platform.PS3);
			IList<BuildInfo> versions = findBuild.GetVersions(new DateTime(2008, 11, 7));

			Assert.AreEqual(1, versions.Count);
			Assert.IsNotNull(GetVersion(versions, 1));
		}

		[Test]
		public void GetFirstByDateVersion()
		{
			FindBuild findBuild = CreateFindBuild();
			BuildInfo version = findBuild.GetFirstVersion(new DateTime(2008, 11, 8));

			Assert.AreEqual(2, version.Number);
		}

		[Test]
		public void GetFirstVersionByDateNone()
		{
			FindBuild findBuild = CreateFindBuild();
			BuildInfo version = findBuild.GetFirstVersion(new DateTime(2008, 11, 1));

			Assert.IsNull(version);
		}

		[Test]
		public void GetLastVersionByDate()
		{
			FindBuild findBuild = CreateFindBuild();
			BuildInfo version = findBuild.GetLastVersion(new DateTime(2008, 11, 8));

			Assert.AreEqual(7, version.Number);
		}

		[Test]
		public void GetLastVersionByDateNone()
		{
			FindBuild findBuild = CreateFindBuild();
			BuildInfo version = findBuild.GetLastVersion(new DateTime(2008, 11, 1));

			Assert.IsNull(version);
		}

		[Test]
		public void GetLastVersions()
		{
			FindBuild findBuild = CreateFindBuild();
			BuildInfo version = findBuild.GetLastVersion(new DateTime(2008, 11, 8));

			Assert.AreEqual(7, version.Number);
		}

		[Test]
		public void GetLastVersion()
		{
			FindBuild findBuild = CreateFindBuild();
			BuildInfo version = findBuild.GetLastVersion();

			Assert.AreEqual(9, version.Number);
		}
	}
}
