using System;
using System.Collections.Generic;
using System.Text;
using BuildTools;
using NUnit.Framework;

namespace UnitTest
{
	[TestFixture]
	public class RetryActionTest
	{
		class FakeRetryAlwaysFail
		{
			private int _timesCalled;

			public FakeRetryAlwaysFail()
			{
				_timesCalled = 0;
			}
			
			public bool Retry()
			{
				_timesCalled++;
				return false;
			}

			public int TimesCalled
			{
				get { return _timesCalled; }
			}
		}

		[Test]
		public void RetryZeroTimes()
		{
			FakeRetryAlwaysFail fakeRetry = new FakeRetryAlwaysFail();
			RetryAction.RetryDelegate retryDelegate = fakeRetry.Retry;

			RetryAction retryAction = new RetryAction(retryDelegate, 0);
			retryAction.Start();

			Assert.AreEqual(0, fakeRetry.TimesCalled);
		}

		[Test]
		public void RetryThreeTimesGoodAtSecond()
		{
			int timesCalled = 0;

			RetryAction.RetryDelegate retryDelegate = delegate()
			{
				timesCalled++;

				return (timesCalled == 2);
			};

			RetryAction retryAction = new RetryAction(retryDelegate, 3);
			retryAction.Start();

			Assert.AreEqual(2, timesCalled);
		}

		[Test]
		public void RetryThreeTimesAlwaysFalse()
		{
			FakeRetryAlwaysFail fakeRetry = new FakeRetryAlwaysFail();
			RetryAction.RetryDelegate retryDelegate = fakeRetry.Retry;
			
			RetryAction retryAction = new RetryAction(retryDelegate, 3);
			retryAction.Start();

			Assert.AreEqual(3,fakeRetry.TimesCalled);
		}
	}
}
