using System;
using System.Collections.Generic;
using System.Text;
using BuildTools;
using NUnit.Framework;

namespace UnitTest
{
	[TestFixture]
	public class VersionListTest
	{
		private Config _config;

		public VersionListTest()
		{
			_config = new Config();
		}

		[Test]
		public void IsSorted()
		{
			BuildInfoList buildInfoList = new BuildInfoList(_config.Storage, _config.Game, Platform.Pc);
			buildInfoList.Update();

			IEnumerator<BuildInfo> buildInfoListEnumerator = buildInfoList.GetEnumerator();

			Assert.IsTrue(buildInfoListEnumerator.MoveNext());
			Assert.AreEqual(2, buildInfoListEnumerator.Current.Number);
			Assert.IsTrue(buildInfoListEnumerator.MoveNext());
			Assert.AreEqual(5, buildInfoListEnumerator.Current.Number);
			Assert.IsTrue(buildInfoListEnumerator.MoveNext());
			Assert.AreEqual(6, buildInfoListEnumerator.Current.Number);
			Assert.IsTrue(buildInfoListEnumerator.MoveNext());
			Assert.AreEqual(7, buildInfoListEnumerator.Current.Number);
			Assert.IsTrue(buildInfoListEnumerator.MoveNext());
			Assert.AreEqual(9, buildInfoListEnumerator.Current.Number);
			Assert.IsFalse(buildInfoListEnumerator.MoveNext());
		}

		[Test]
		public void RevertEnumerator()
		{
			BuildInfoList buildInfoList = new BuildInfoList(_config.Storage, _config.Game, Platform.Pc);
			buildInfoList.Update();

			IEnumerator<BuildInfo> buildInfoListEnumerator = buildInfoList.Reverse.GetEnumerator();

			Assert.IsTrue(buildInfoListEnumerator.MoveNext());
			Assert.AreEqual(9, buildInfoListEnumerator.Current.Number);
			Assert.IsTrue(buildInfoListEnumerator.MoveNext());
			Assert.AreEqual(7, buildInfoListEnumerator.Current.Number);
			Assert.IsTrue(buildInfoListEnumerator.MoveNext());
			Assert.AreEqual(6, buildInfoListEnumerator.Current.Number);
			Assert.IsTrue(buildInfoListEnumerator.MoveNext());
			Assert.AreEqual(5, buildInfoListEnumerator.Current.Number);
			Assert.IsTrue(buildInfoListEnumerator.MoveNext());
			Assert.AreEqual(2, buildInfoListEnumerator.Current.Number);
			Assert.IsFalse(buildInfoListEnumerator.MoveNext());
		}

	}
}
