#include "CommandManager.h"
#include "ICommand.h"

bool CCommandManager::RegisterCommand(ICommand*	piCommand)
{
	CCommandManager	&oCommandManager(GetCommandManager());
	return oCommandManager.RegisterCommandImplementation(piCommand);
}

bool CCommandManager::ProcessCommand(IConCom	*pConCom,int nNumberOfArguments,char** aszArguments,bool& bCommandResult)
{
	for (size_t nCount(0),nTotal(cCommands.size());nCount<nTotal;++nCount)
	{
		if (cCommands[nCount]->ProcessCommand(pConCom,nNumberOfArguments,aszArguments,bCommandResult))
		{
			return true;
		}
	}

	return false;
}

CCommandManager&	CCommandManager::GetCommandManager()
{
	static CCommandManager	oCommandManager;
	return oCommandManager;
}

CCommandManager::CCommandManager()
{

}

bool CCommandManager::RegisterCommandImplementation(ICommand*	piCommand)
{
	for (size_t nCount(0),nTotal(cCommands.size());nCount<nTotal;++nCount)
	{
		if (cCommands[nCount]==piCommand)
		{
			return false;
		}
	}

	cCommands.push_back(piCommand);
	return true;
}
