#ifndef CommandRegisterHelper_h__
#define CommandRegisterHelper_h__

#pragma once

#include "CommandManager.h"

template <typename TImplementation> class TCommandRegisterHelper
{
public:
	TCommandRegisterHelper();

	static TImplementation* GetImplementation();
};

template <typename TImplementation>
TCommandRegisterHelper<TImplementation>::TCommandRegisterHelper()
{
	CCommandManager::RegisterCommand(TCommandRegisterHelper<TImplementation>::GetImplementation());
}

template <typename TImplementation>
TImplementation* TCommandRegisterHelper<TImplementation>::GetImplementation()
{
	static TImplementation	oImplementation;
	return &oImplementation;
}

#define AUTOREGISTERCLASS(tClass)	namespace AutoRegister{ TCommandRegisterHelper<tClass> oHelper##tClass;}

#endif // CommandRegisterHelper_h__
