#include <stdio.h>

#include "X360Com.h"
#include "PS3Com.h"

#include "CommandManager.h"
#include "ErrorValues.h"

#include "ICommand.h"


IConComManager *pManager = NULL;

void Shutdown()
{
	if (pManager)
		pManager->Release();
	pManager = NULL;
}

int ReturnFailed()
{
	::printf("failed");
	Shutdown();
	return NULL;
}

int main(int argumentCount, char **pArguments)
{
	if (argumentCount < 4)
	{
		::printf("failed(%d)\n",ERROR_WRONG_PARAMETER_COUNT);

		::printf("Wrong parameters\n");

		::printf("\nCorrect usage:\n\n");

		::printf("concom [X360|PS3] <*|Console Name> [GetIP|FileCopyTo|FileCopyFrom|Launch]\n <parameters>\n\n");
		::printf("[] indicates mandatory parameter\n");
		::printf("<> indicates optional  parameter\n");
		::printf("|  indicates that this parameter must be one of the listed items\n");
		::printf("*  tells concom to use the the default connected console\n\n");
		::printf("Examples: \n\n");
		::printf("concom X360 * GetIP\n\n");
		::printf("concom X360 tools FileCopyTo \"c:\\My Source Directory\\My SourceFile.bin\"\n \"e:\\My Game Target Game Directory\\\" \n\n");
		::printf("concom X360 * FileCopyFrom \"e:\\My Remote Source Directory\\My SourceFile.bin\"\n \"e:\\My Game Local Target Directory\\\" \n\n");
		::printf("concom PS3 * Launch \"/dev_hdd0/game/Game02/My Self File.self\"\n \"/dev_hdd0/My Working Directory/\" My long list of parameteres\n\n");

		Shutdown();
		return NULL;
	}

#ifdef _DEBUG
	MessageBox(GetDesktopWindow(),"Attach the debugger to the app now.","Attach Debugger",MB_ICONEXCLAMATION|MB_OK);
#endif //_DEBUG

	if (::_stricmp(pArguments[1], "XB360") == 0 || ::_stricmp(pArguments[1], "X360") == 0)
	{
		pManager = CX360ComManager::Create();
	}
	else if (::_stricmp(pArguments[1], "PS3") == 0)
	{
		pManager = CPS3ComManager::Create();
	}
	else
	{
		::printf("failed(%d)\n",ERROR_FIRST_PARAMETER_NOT_PLATFORM);
		::printf("Wrong parameter: The first parameter must be the platform, or XB360 or PS3.\n");
		Shutdown();
		return NULL;
	}

	if (!pManager)
	{
		::printf("failed(%d)\n",ERROR_API_INIT_FAILED);
		printf("Failed to access the console API (%s). Check your API setup.\n",pArguments[1]);
		Shutdown();
		return NULL;
	}

	if (!pManager->GetTargetCount())
	{
		::printf("failed(%d)\n",ERROR_NO_CONSOLE_REGISTERED_ON_API);
		::printf("Failed to find any console for the specified platform (%s).\n",pArguments[1]);
		Shutdown();
		return NULL;
	}

	IConCom *pConCom = NULL;
	if (pArguments[2][0] == '*')
	{
		pConCom = pManager->ConnectToTarget(0);
	}
	else
	{
		pConCom = pManager->ConnectToTargetByName(pArguments[2]);
	}

	if (!pConCom)
	{
		::printf("failed(%d)\n",ERROR_FAILED_TO_CONNECT_TO_CONSOLE);
		::printf("Failed to connect to the specified console (%s)\n",pArguments[2]);
		Shutdown();
		return NULL;
	}
		

	bool boCommandResult(false);
	CCommandManager& oCommandManager(CCommandManager::GetCommandManager());

	if (!oCommandManager.ProcessCommand(pConCom,argumentCount,pArguments,boCommandResult))
	{
		::printf("failed(%d)\n",ERROR_UNKNOWN_COMMAND);
		::printf("Invalid Command: (%s)\n",pArguments[3]);

		::printf("\nCorrect usage:\n\n");

		::printf("concom [X360|PS3] <*|Console Name> [GetIP|FileCopyTo|FileCopyFrom|Launch]\n <parameters>\n\n");
		::printf("[] indicates mandatory parameter\n");
		::printf("<> indicates optional  parameter\n");
		::printf("|  indicates that this parameter must be one of the listed items\n");
		::printf("*  tells concom to use the the default connected console\n\n");
		::printf("Examples: \n\n");
		::printf("concom X360 * GetIP\n\n");
		::printf("concom X360 tools FileCopyTo \"c:\\My Source Directory\\My SourceFile.bin\"\n \"e:\\My Game Target Game Directory\\\" \n\n");
		::printf("concom X360 * FileCopyFrom \"e:\\My Remote Source Directory\\My SourceFile.bin\"\n \"e:\\My Game Local Target Directory\\\" \n\n");
		::printf("concom PS3 * Launch \"/dev_hdd0/game/Game02/My Self File.self\"\n \"/dev_hdd0/My Working Directory/\" My long list of parameteres\n\n");
	}

	pConCom->Release();
	return NULL;
}
