#ifndef HEADER_ConCom
#define HEADER_ConCom

struct IConCom
{
	virtual void Release() = 0;

	virtual const char *GetIP() = 0;

	virtual bool FileCopyTo(const char *localSource, const char *remoteDestination) = 0;
	virtual bool FileCopyFrom(const char *remoteSource, const char *localDestination) = 0;

	// Parameters:
	//	 szSourceDirectory: For PS3 only, the directory where the 
	virtual bool Launch(const char* szProgramFullFilename,const char* szWorkingDirectory=NULL,unsigned int nArguments=0,const char** szProgramArguments=NULL)=0;
};

struct IConComManager
{
	virtual void Release() = 0;

	virtual unsigned int GetTargetCount() = 0;
	virtual const char *GetTargetName(unsigned int index) = 0;

	virtual IConCom *ConnectToTarget(unsigned int index) = 0;

	virtual IConCom *ConnectToTargetByName(const char *name) = 0;
};

#endif // HEADER_ConCom
