#include <stdio.h>
#include <cstring>
#include "FileCopyFrom.h"
#include "CommandRegisterHelper.h"
#include "ErrorValues.h"
#include "ConCom.h"

bool CFileCopyFrom::ProcessCommand(IConCom*	pConCom,int nNumberOfArguments,char** aszArguments,bool &rbCommandResult)
{
	if (::_stricmp(aszArguments[3], "FileCopyFrom") == NULL)
	{
		if (nNumberOfArguments == 6)
		{
			if (pConCom->FileCopyFrom(aszArguments[4], aszArguments[5]))
			{
				::printf("copied \"%s\" to \"%s\"", aszArguments[4], aszArguments[5]);
				rbCommandResult=true;
			}
			else
			{
				::printf("failed(%d)\n",ERROR_FAILED_TO_COPY_FILES_FROM_CONSOLE);
				::printf("Failed to copy files from the console.\n");
				rbCommandResult=false;
			}
		}
		else
		{
			::printf("failed(%d)\n",ERROR_WRONG_PARAMETER_COUNT);
			::printf("Wrong number of arguments for command FileCopyFrom:\n Only 2 file arguments should be used.\n");
			rbCommandResult=false;
		}
		return true;
	}
	return false;
}

AUTOREGISTERCLASS(CFileCopyFrom);
