#include <stdio.h>
#include <cstring>
#include "GetIP.h"
#include "CommandRegisterHelper.h"
#include "ErrorValues.h"
#include "ConCom.h"

bool CGetIP::ProcessCommand(IConCom*	pConCom,int nNumberOfArguments,char** aszArguments,bool &rbCommandResult)
{
	if (::_stricmp(aszArguments[3], "GetIP") == NULL)
	{
		if (nNumberOfArguments==4)
		{
			if (const char *ip = pConCom->GetIP())
			{
				::printf(ip);
				rbCommandResult=true;
			}
			else
			{
				::printf("failed(%d)\n",ERROR_FAILED_TO_RETRIEVE_CONSOLE_IP);
				::printf("Failed to get the IP address for the selected console: (%s)\n",aszArguments[2],aszArguments[1]);
				rbCommandResult=false;
			}
		}
		else
		{
			::printf("failed(%d)\n",ERROR_WRONG_PARAMETER_COUNT);
			::printf("Wrong number of arguments for command GetIp:\n This command requires no arguments.\n");
			rbCommandResult=false;
		}
		return true;
	}
	return false;
}

AUTOREGISTERCLASS(CGetIP);
