#include <stdio.h>
#include <cstring>
#include "Launch.h"
#include "CommandRegisterHelper.h"
#include "ErrorValues.h"
#include "ConCom.h"

bool CLaunch::ProcessCommand(IConCom*	pConCom,int nNumberOfArguments,char** aszArguments,bool &rbCommandResult)
{
	if (::_stricmp(aszArguments[3], "Launch") == NULL)
	{
		if (nNumberOfArguments > 4)
		{
			if (
				pConCom->Launch
				(
				aszArguments[4],
				(nNumberOfArguments > 5)?aszArguments[5]:NULL,
				(nNumberOfArguments > 6)?nNumberOfArguments-6:0,
				(nNumberOfArguments > 6)?(const char**)(aszArguments+6):NULL
				)
				)
			{
				::printf("launched application \"%s\".", aszArguments[4]);
				rbCommandResult=true;
			}
			else
			{
				::printf("failed(%d)\n",ERROR_FAILED_TO_LAUNCH_APP_ON_CONSOLE);
				::printf("Failed to launch app (%s) on the console (%s) in platform (%s).\n",aszArguments[4],aszArguments[2],aszArguments[1]);
				rbCommandResult=false;
			}
		}
		else
		{
			::printf("failed(%d)\n",ERROR_WRONG_PARAMETER_COUNT);
			::printf("Wrong number of arguments for command Launch:\n it requires a minimum of 4 arguments.\n");
			rbCommandResult=false;
		}
		return true;
	}
	return false;
}

AUTOREGISTERCLASS(CLaunch);
