#include "PS3Com.h"
#include "StringHelper.h"
#include <cassert>

#define MINIMUM_CONNECTION_TIMEOUT 1000
#define DEFAULT_CONNECTION_TIMEOUT 6000
/*

  CPS3Com

*/

void __stdcall CPS3Com::SNPS3FTPEvenCallback(HTARGET hTarget, UINT eventType, UINT parameter, SNRESULT snResult, UINT length, BYTE *pData, void *pUser)
{
	CPS3Com *pInstance = (CPS3Com *)pUser;

	TMAPI_FT_NOTIFICATION *pNotifications = (TMAPI_FT_NOTIFICATION *)pData;

	UINT count = length / sizeof(TMAPI_FT_NOTIFICATION);
	for (UINT i=0; i<count; ++i)
	{
		switch (pNotifications[i].m_Type)
		{
		case TMAPI_FT_PROGRESS:
//			::printf("progress\n");
//			::printf("progress id=%d tx=%d\n",
//				pNotifications[i].m_TransferID,
//				pNotifications[i].m_BytesTransferred);
			pInstance->m_ftpProgress = TMAPI_FT_PROGRESS;
			break;

		case TMAPI_FT_FINISH:
//			::printf("finished\n");
//			::printf("finish id=%d tx=%d\n",
//				pNotifications[i].m_TransferID,
//				pNotifications[i].m_BytesTransferred);
			pInstance->m_ftpProgress = TMAPI_FT_FINISH;
			break;

		case TMAPI_FT_SKIPPED:
//			::printf("skipped\n");
//			::printf("skipped id=%d tx=%d\n",
//				pNotifications[i].m_TransferID,
//				pNotifications[i].m_BytesTransferred);
			pInstance->m_ftpProgress = TMAPI_FT_SKIPPED;
			break;

		case TMAPI_FT_ERROR:
//			::printf("error\n");
			pInstance->m_ftpProgress = TMAPI_FT_ERROR;
			break;
		}
	}
}

//

CPS3Com::CPS3Com(SNPS3TMDynamicAPI *pSNPS3TM, TargetInfo &targetInfo)
{
	m_pSNPS3TM = pSNPS3TM;
	m_targetInfo = targetInfo;
}

CPS3Com::~CPS3Com()
{
	m_pSNPS3TM->Disconnect(m_targetInfo.hTarget);
}

// ConCom

const char *CPS3Com::GetIP()
{
	static char ip[16];
	ip[15] = '\0';

	//::printf("pszType=%s\n", m_targetInfo.pszType);

	if (::strcmp(m_targetInfo.pszType, "PS3_DBG_DEX") == 0)
	{
		TMAPI_TCPIP_CONNECT_PROP connection;
		m_pSNPS3TM->GetConnectionInfo(m_targetInfo.hTarget, &connection);
		::memcpy(ip, connection.szIPAddress, 15);
		return ip;
	}

	SNPS3GamePortIPAddressData snps3GamePortIPAddressData;
	SNRESULT snResult = m_pSNPS3TM->GetGamePortIPAddrData(
		m_targetInfo.hTarget, "eth0", &snps3GamePortIPAddressData);
	if (SN_FAILED(snResult))
	{
		//::printf("GetGamePortIPAddrData() failed snResult=%d\n", snResult);
		return NULL;
	}

	sprintf_s(ip, 16, "%d.%d.%d.%d", 
		((unsigned char *)&snps3GamePortIPAddressData.uIPAddress)[3],
		((unsigned char *)&snps3GamePortIPAddressData.uIPAddress)[2],
		((unsigned char *)&snps3GamePortIPAddressData.uIPAddress)[1],
		((unsigned char *)&snps3GamePortIPAddressData.uIPAddress)[0]);
	return ip;
}

bool CPS3Com::FileCopyTo(const char *localSource, const char *remoteDestination)
{
	SNRESULT snResult = m_pSNPS3TM->RegisterFTPEventHandler(
		m_targetInfo.hTarget, SNPS3FTPEvenCallback, this);
	if (SN_FAILED(snResult))
		return false;

	m_ftpProgress = TMAPI_FT_PROGRESS;

	UINT id;
	snResult = m_pSNPS3TM->UploadFile(
		m_targetInfo.hTarget, localSource, remoteDestination, &id);
	if (SN_FAILED(snResult))
	{
		m_pSNPS3TM->CancelFTPEvents(m_targetInfo.hTarget);
		return false;
	}

	for (;;)
	{
		m_pSNPS3TM->Kick();
		if (m_ftpProgress != TMAPI_FT_PROGRESS)
			break;
	}

	m_pSNPS3TM->CancelFTPEvents(m_targetInfo.hTarget);

	switch (m_ftpProgress)
	{
	case TMAPI_FT_FINISH:
	case TMAPI_FT_SKIPPED:
		return true;
	case TMAPI_FT_ERROR:
		return false;
	}

	return false;
}

bool CPS3Com::FileCopyFrom(const char *remoteSource, const char *localDestination)
{
	SNRESULT snResult = m_pSNPS3TM->RegisterFTPEventHandler(
		m_targetInfo.hTarget, SNPS3FTPEvenCallback, this);
	if (SN_FAILED(snResult))
		return false;

	m_ftpProgress = TMAPI_FT_PROGRESS;

	UINT id;
	snResult = m_pSNPS3TM->DownloadFile(
		m_targetInfo.hTarget, remoteSource, localDestination, &id);
	if (SN_FAILED(snResult))
	{
		m_pSNPS3TM->CancelFTPEvents(m_targetInfo.hTarget);
		return false;
	}

	for (;;)
	{
		m_pSNPS3TM->Kick();
		if (m_ftpProgress != TMAPI_FT_PROGRESS)
			break;
	}

	m_pSNPS3TM->CancelFTPEvents(m_targetInfo.hTarget);

	switch (m_ftpProgress)
	{
	case TMAPI_FT_FINISH:
	case TMAPI_FT_SKIPPED:
		return true;
	case TMAPI_FT_ERROR:
		return false;
	}

	return false;
}

bool CPS3Com::Launch(const char* szProgramFullFilename,const char* szWorkingDirectory,unsigned int nArguments,const char** szProgramArguments)
{
	size_t												nDirectoryLenght(0);
	std::string										strExecuablePath(szProgramFullFilename);
	std::string										strPath(szProgramFullFilename);
	std::string										strAppExecutable(szProgramFullFilename);
	std::vector<const char*>			cszArguments;

	::replace_chars(strPath, '\\', '/');

	if (
			(!szWorkingDirectory)
			||
			(_stricmp(szWorkingDirectory,".")==0)
		 )
	{
		nDirectoryLenght=Path::GetLengthWithoutFile(szProgramFullFilename);
		strPath.resize(nDirectoryLenght);
		strExecuablePath.resize(nDirectoryLenght);
	}
	else
	{
		strPath=szWorkingDirectory;

		nDirectoryLenght=Path::GetLengthWithoutFile(szProgramFullFilename);		
		strExecuablePath.resize(nDirectoryLenght);
	}

	// Reset before launching.
	if (!Reset())
	{
		return false;
	}

	SNPS3TargetInfo target;
	target.pszHomeDir = strExecuablePath.c_str();
	target.pszFSDir = strExecuablePath.c_str();
	target.nFlags = SN_TI_FILESERVEDIR | SN_TI_HOMEDIR | SN_TI_TARGETID;
	target.hTarget = m_targetInfo.hTarget;
	target.boot = m_targetInfo.boot;
	target.pszName = &m_targetInfo.pszName[0];
	target.pszInfo = &m_targetInfo.pszInfo[0];
	target.pszType = &m_targetInfo.pszType[0];


	// We are allowing exactly 1 communication failure.
	for (int i=0;i<2;++i)
	{
		SNRESULT snResult = m_pSNPS3TM->SetTargetInfo(&target);
		if (SN_FAILED(snResult))
		{
			// If the error was a communication failure...
			if (snResult==SN_E_TM_COMMS_ERR)
			{

				if (!ResetConnection())
				{
					assert(!"Unresolvable connection failure.");
					return false;
				}
				else
				{
					continue;
				}
			}
			return false;
		}

		cszArguments.resize(nArguments+1);
		cszArguments[0]=strAppExecutable.c_str();
		for (size_t nCount=0;nCount<nArguments;++nCount)
		{
			cszArguments[nCount+1]=szProgramArguments[nCount];
		}

		snResult = m_pSNPS3TM->ProcessLoad(
			m_targetInfo.hTarget,
			SNPS3_DEF_PROCESS_PRI,
			strAppExecutable.c_str(),
			(int)cszArguments.size(),&cszArguments.front(),
			0, NULL,
			NULL,
			NULL,
			0);

		if (SN_FAILED(snResult))
		{
			if (snResult==SN_E_TM_COMMS_ERR)
			{
				if (!ResetConnection())
				{
					assert(!"Unresolvable connection failure.");
					return false;
				}
				else
				{
					continue;
				}
			}
			return false;
		}

		break;
	}

	return true;
}

bool CPS3Com::Reset()
{
	SNRESULT snResult = m_pSNPS3TM->ResetEx
		(
		m_targetInfo.hTarget,
		/*SNPS3TM_BOOTP_BD_EMU_ON|*/SNPS3TM_BOOTP_DEBUG_MODE,SNPS3_BOOT_DEFAULT_MASK,	
		SNPS3TM_RESETP_HARD_RESET,SNPS3TM_RESETP_ALL_MASK,
		SNPS3TM_SYSTEMP_TARGET_MODEL,SNPS3TM_SYSTEMP_TARGET_MODEL
		);
	return !SN_FAILED(snResult);
}

bool CPS3Com::ResetConnection()
{
	SNRESULT snResult;
	
	snResult=m_pSNPS3TM->CloseTargetComms();
	if (SN_FAILED(snResult))
	{
		return false;
	}
		
	snResult=m_pSNPS3TM->InitTargetComms();
	if (SN_FAILED(snResult))
	{
		return false;
	}

	return true;
}


/*

  CPS3ComManager

*/

int __stdcall CPS3ComManager::SNPS3EnumerateTargetsCallback(HTARGET hTarget, void *pUser)
{
	CPS3ComManager *pInstance = (CPS3ComManager *)pUser;

	SNPS3_TM_TIMEOUT timeoutIDs[1];
	UINT32 timeouts[1];
	timeoutIDs[0] = CONNECT_TIMEOUT;
	timeouts[0] = MINIMUM_CONNECTION_TIMEOUT;

	pInstance->m_pSNPS3TM->SetTimeouts(hTarget,1,&timeoutIDs[0],&timeouts[0]);

	long powerStatus;
	ECONNECTSTATUS uConnectStatus;
	char * buffer;
	SNRESULT result = pInstance->m_pSNPS3TM->GetConnectionStatus(hTarget,&uConnectStatus,&buffer);
	if ( !SN_FAILED(result) && uConnectStatus != ECONNECTSTATUS::CS_CONNECTED )
	{
		pInstance->m_pSNPS3TM->Connect(hTarget, NULL);
		pInstance->m_pSNPS3TM->GetPowerStatus(hTarget, &powerStatus);
		pInstance->m_pSNPS3TM->Disconnect(hTarget);
	}

	SNPS3TargetInfo targetInfo; 
	targetInfo.hTarget = hTarget;
	targetInfo.nFlags = SN_TI_TARGETID;
	pInstance->m_pSNPS3TM->GetTargetInfo(&targetInfo);

	TargetInfo copyTargetInfo(targetInfo);
	pInstance->m_snps3TargetInfos.push_back(copyTargetInfo);

	timeouts[0] = DEFAULT_CONNECTION_TIMEOUT;
	pInstance->m_pSNPS3TM->SetTimeouts(hTarget,1,&timeoutIDs[0],&timeouts[0]);

	return 0;
}

//

CPS3ComManager *CPS3ComManager::Create()
{
	CPS3ComManager *pInstance = new CPS3ComManager();
	if (!pInstance->Initialize())
	{
		delete pInstance;
		return NULL;
	}

	return pInstance;
}

//

CPS3ComManager::CPS3ComManager()
{
	m_pSNPS3TM = NULL;
}

CPS3ComManager::~CPS3ComManager()
{
	if (!m_pSNPS3TM)
		return;

	m_pSNPS3TM->CloseTargetComms();

	m_pSNPS3TM->Release();
	m_pSNPS3TM = NULL;
}

//

bool CPS3ComManager::Initialize()
{
	m_pSNPS3TM = SNPS3TMDynamicAPI::Create();
	if (!m_pSNPS3TM)
		return false;

	SNRESULT snResult = m_pSNPS3TM->InitTargetComms();
	if (SN_FAILED(snResult))
		return false;

	snResult = m_pSNPS3TM->EnumerateTargetsEx(
		SNPS3EnumerateTargetsCallback, this);
	if (SN_FAILED(snResult))
		return false;

	return true;
}

// IConComManager

unsigned int CPS3ComManager::GetTargetCount()
{
	return (unsigned int)m_snps3TargetInfos.size();
}

const char *CPS3ComManager::GetTargetName(unsigned int index)
{
	return m_snps3TargetInfos[index].pszName;
}

IConCom *CPS3ComManager::ConnectToTarget(unsigned int index)
{
	SNRESULT snResult = m_pSNPS3TM->Connect(
		m_snps3TargetInfos[index].hTarget, NULL);
	if (SN_FAILED(snResult))
		return NULL;

	return new CPS3Com(m_pSNPS3TM, m_snps3TargetInfos[index]);
}

IConCom *CPS3ComManager::ConnectToTargetByName(const char *name)
{
	//::printf("CPS3ComManager::ConnectToTargetByName() name=%s\n", name);

	for (size_t i=0; i<m_snps3TargetInfos.size(); ++i)
	{
		//::printf("trying target %d name=%s\n", i, m_snps3TargetInfos[i].pszName);

		if (::_stricmp(m_snps3TargetInfos[i].pszName, name) == 0)
		{
			//::printf("found target: %s", m_snps3TargetInfos[i].pszName);
			SNRESULT snResult = m_pSNPS3TM->Connect(
				m_snps3TargetInfos[i].hTarget, NULL);
			if (SN_FAILED(snResult))
				return NULL;

			return new CPS3Com(m_pSNPS3TM, m_snps3TargetInfos[i]);
		}
	}

	return NULL;
}
