#ifndef HEADER_PS3Com
#define HEADER_PS3Com

#include <vector>
#include <Windows.h>
#include "SNPS3TMDynamicAPI.h"
#include "ConCom.h"


struct TargetInfo
{
	TargetInfo()
	{
		hTarget = -1;
		nFlags = -1;
		boot = -1;
		memset(pszName,'\0',sizeof(pszName));
		memset(pszFSDir,'\0',sizeof(pszFSDir));
		memset(pszHomeDir,'\0',sizeof(pszHomeDir));
		memset(pszInfo,'\0',sizeof(pszInfo));
		memset(pszType,'\0',sizeof(pszType));
	}

	TargetInfo(const SNPS3TargetInfo& targetInfo )
	{
		hTarget = targetInfo.hTarget;
		nFlags = targetInfo.nFlags;
		boot = targetInfo.boot;
		strncpy(pszName,targetInfo.pszName,sizeof(pszName));
		strncpy(pszFSDir,targetInfo.pszFSDir,sizeof(pszFSDir));
		strncpy(pszHomeDir,targetInfo.pszHomeDir,sizeof(pszHomeDir));
		strncpy(pszInfo,targetInfo.pszInfo,sizeof(pszInfo));
		strncpy(pszType,targetInfo.pszType,sizeof(pszType));
	}

	char pszName[256];
	char pszFSDir[256];
	char pszHomeDir[256];
	char pszInfo[256];
	char pszType[256];
	HTARGET hTarget;
	UINT nFlags;
	UINT64 boot;
};

class CPS3Com :
	public IConCom
{
public:
	typedef void (CPS3Com::*SNPS3ThreadFunc)(void);

	static void __stdcall SNPS3FTPEvenCallback(HTARGET hTarget, UINT eventType, UINT parameter, SNRESULT snResult, UINT length, BYTE *pData, void *pUser);

public:
	CPS3Com(SNPS3TMDynamicAPI *pSNPS3TM, TargetInfo &targetInfo);
	~CPS3Com();

	// ConCom
public:
	virtual void Release() { delete this; }

	virtual const char *GetIP();

	virtual bool FileCopyTo(const char *localSource, const char *remoteDestination);
	virtual bool FileCopyFrom(const char *remoteSource, const char *localDestination);

	virtual bool Launch(const char* szProgramFullFilename,const char* szWorkingDirectory=NULL,unsigned int nArguments=0,const char** szProgramArguments=NULL);

	bool Reset();
	bool ResetConnection();

protected:

	//bool   PrepareConfigurationFiles(const char* szProgramFullFilename,const char* szProgramArguments=NULL);

private:
	SNPS3TMDynamicAPI	*m_pSNPS3TM;
	TargetInfo			m_targetInfo;
	unsigned int		m_ftpProgress;
};

class CPS3ComManager :
	public IConComManager
{
public:
	static CPS3ComManager *Create();

private:
	static int __stdcall SNPS3EnumerateTargetsCallback(HTARGET hTarget, void *pUser);

private:
	CPS3ComManager();
	~CPS3ComManager();

private:
	bool Initialize();

	// IConComManager
public:
	virtual void Release() { delete this; }

	virtual unsigned int GetTargetCount();
	virtual const char *GetTargetName(unsigned int index);

	virtual IConCom *ConnectToTarget(unsigned int index);

	virtual IConCom *ConnectToTargetByName(const char *name);

private:
	SNPS3TMDynamicAPI *m_pSNPS3TM;
	
	std::vector<TargetInfo> m_snps3TargetInfos;
};

#endif // HEADER_PS3Com
