#include <Windows.h>
#include "SNPS3TMDynamicAPI.h"

/*

  SNPS3TMDynamicAPI

*/

size_t SNPS3TMDynamicAPI::s_refCount = 0;

//

SNPS3TMDynamicAPI *SNPS3TMDynamicAPI::Create()
{
	static SNPS3TMDynamicAPI instance;

	if (!s_refCount)
	{
		if (!instance.Initialize())
			return NULL;
	}

	++s_refCount;
	return &instance;
}

//

SNPS3TMDynamicAPI::SNPS3TMDynamicAPI()
{
	m_hModule = NULL;
}

SNPS3TMDynamicAPI::~SNPS3TMDynamicAPI()
{
}

//

bool SNPS3TMDynamicAPI::Initialize()
{
	m_hModule = ::LoadLibrary("PS3TMAPI.DLL");
	if (!m_hModule)
		return false;

	if (!(GetTargetInfo = (FGetTargetInfo)::GetProcAddress(m_hModule, "SNPS3GetTargetInfo")) ||
		!(InitTargetComms = (FInitTargetComms)::GetProcAddress(m_hModule, "SNPS3InitTargetComms")) ||
		!(EnumerateTargetsEx = (FEnumerateTargetsEx)::GetProcAddress(m_hModule, "SNPS3EnumerateTargetsEx")) ||
		!(CloseTargetComms = (FCloseTargetComms)::GetProcAddress(m_hModule, "SNPS3CloseTargetComms")) ||
		!(GetDirectoryList = (FGetDirectoryList)::GetProcAddress(m_hModule, "SNPS3GetDirectoryList")) ||
		!(ProcessLoad = (FProcessLoad)::GetProcAddress(m_hModule, "SNPS3ProcessLoad")) ||
		!(Connect = (FConnect)::GetProcAddress(m_hModule, "SNPS3Connect")) ||
		!(RegisterTTYEventHandler = (FRegisterTTYEventHandler)::GetProcAddress(m_hModule, "SNPS3RegisterTTYEventHandler")) ||
		!(RegisterFTPEventHandler = (FRegisterFTPEventHandler)::GetProcAddress(m_hModule, "SNPS3RegisterFTPEventHandler")) ||
		!(Disconnect = (FDisconnect)::GetProcAddress(m_hModule, "SNPS3Disconnect")) ||
		!(SetTargetInfo = (FSetTargetInfo)::GetProcAddress(m_hModule, "SNPS3SetTargetInfo")) ||
		!(Reset = (FReset)::GetProcAddress(m_hModule, "SNPS3Reset")) ||
		!(ResetEx = (FResetEx)::GetProcAddress(m_hModule, "SNPS3ResetEx")) ||
		!(Delete = (FDelete)::GetProcAddress(m_hModule, "SNPS3Delete")) ||
		!(DownloadFile = (FDownloadFile)::GetProcAddress(m_hModule, "SNPS3DownloadFile")) ||
		!(MakeDirectory = (FMakeDirectory)::GetProcAddress(m_hModule, "SNPS3MakeDirectory")) ||
		!(UploadFile = (FUploadFile)::GetProcAddress(m_hModule, "SNPS3UploadFile")) ||
		!(Kick = (FKick)::GetProcAddress(m_hModule, "SNPS3Kick")) ||
		!(CancelFTPEvents = (FCancelFTPEvents)::GetProcAddress(m_hModule, "SNPS3CancelFTPEvents")) ||
		!(CancelTTYEvents = (FCancelTTYEvents)::GetProcAddress(m_hModule, "SNPS3CancelTTYEvents")) ||
		!(GetPowerStatus = (FGetPowerStatus)::GetProcAddress(m_hModule, "SNPS3GetPowerStatus")) ||
		!(GetConnectionStatus = (FGetConnectionStatus)::GetProcAddress(m_hModule, "SNPS3GetConnectStatus")) ||
		!(ProcessList = (FProcessList)::GetProcAddress(m_hModule, "SNPS3ProcessList")) ||
		!(ProcessInfo = (FProcessInfo)::GetProcAddress(m_hModule, "SNPS3ProcessInfo")) ||
		!(GetGamePortIPAddrData = (FGetGamePortIPAddrData)::GetProcAddress(m_hModule, "SNPS3GetGamePortIPAddrData")) ||
		!(GetConnectionInfo = (FGetConnectionInfo)::GetProcAddress(m_hModule, "SNPS3GetConnectionInfo")) ||
		!(SetTimeouts = (FSetTimeouts)::GetProcAddress(m_hModule, "SNPS3SetTimeouts")))
	{
		Shutdown();
		return false;
	}

	return true;
}

void SNPS3TMDynamicAPI::Shutdown()
{
	if (m_hModule)
		::FreeLibrary(m_hModule);
	m_hModule = NULL;
}

//

void SNPS3TMDynamicAPI::Release()
{
	if (!s_refCount)
		return;

	--s_refCount;
	if (s_refCount)
		return;

	Shutdown();
}
