#ifndef HEADER_SNPS3TMDynamicAPI
#define HEADER_SNPS3TMDynamicAPI

#include <ps3tmapi.h>

// Wrapper class to dynamically load the SN PlayStation 3 Target Manager API.
class SNPS3TMDynamicAPI
{
public:
	static SNPS3TMDynamicAPI *Create();

private:
	static size_t s_refCount;

private:
	SNPS3TMDynamicAPI();
	~SNPS3TMDynamicAPI();

public:
	void Release();

private:
	bool Initialize();
	void Shutdown();

private:
	HMODULE m_hModule;

private:
	typedef SNRESULT (*FGetTargetInfo)(SNPS3TargetInfo *);
	typedef SNRESULT (*FInitTargetComms)(void);
	typedef SNRESULT (*FEnumerateTargetsEx)(TMAPI_EnumTargetsExCallback, void *);
	typedef SNRESULT (*FCloseTargetComms)(void);
	typedef SNRESULT (*FGetDirectoryList)(HTARGET, const char *, UINT*, SNPS3DirEntry *);
	typedef SNRESULT (*FProcessLoad)(HTARGET, UINT, const char *, int, const char **, int, const char **, UINT *, UINT64 *, UINT);
	typedef SNRESULT (*FConnect)(HTARGET, const char *);
	typedef SNRESULT (*FRegisterTTYEventHandler)(HTARGET, UINT, TMAPI_HandleEventCallback, void *);
	typedef SNRESULT (*FRegisterFTPEventHandler)(HTARGET, TMAPI_HandleEventCallback, void *);
	typedef SNRESULT (*FDisconnect)(HTARGET);
	typedef SNRESULT (*FSetTargetInfo)(SNPS3TargetInfo *);
	typedef SNRESULT (*FReset)(HTARGET, UINT64);
	typedef SNRESULT (*FResetEx)(HTARGET hTarget, UINT64 uBoot, UINT64 uBootMask, UINT64 uReset, UINT64 uResetMask,	UINT64 uSystem, UINT64 uSystemMask);
	typedef SNRESULT (*FDelete)(HTARGET, const char *);
	typedef SNRESULT (*FDownloadFile)(HTARGET, const char *, const char *, UINT *);
	typedef SNRESULT (*FMakeDirectory)(HTARGET, const char *, UINT);
	typedef SNRESULT (*FUploadFile)(HTARGET, const char *, const char *, UINT *);
	typedef SNRESULT (*FKick)(void);
	typedef SNRESULT (*FCancelFTPEvents)(HTARGET);
	typedef SNRESULT (*FCancelTTYEvents)(HTARGET, UINT);
	typedef SNRESULT (*FGetPowerStatus)(HTARGET, long *);
	typedef SNRESULT (*FGetConnectionStatus)(HTARGET ,ECONNECTSTATUS *, char **);

	typedef SNRESULT (*FProcessList)(HTARGET, UINT *, UINT *);
	typedef SNRESULT (*FProcessInfo)(HTARGET, UINT, UINT *, SNPS3PROCESSINFO *);
	typedef SNRESULT (*FGetGamePortIPAddrData)(HTARGET hTarget, char const* szDeviceName, SNPS3GamePortIPAddressData* pData);

	typedef SNRESULT (*FGetConnectionInfo)(HTARGET hTarget, TMAPI_TCPIP_CONNECT_PROP *pConnection);;
	typedef SNRESULT (*FSetTimeouts)(HTARGET hTarget, UINT32 uNoTimeouts, SNPS3_TM_TIMEOUT * pTimeoutIDs, UINT32 *	puTimeoutValues);

public:
	FGetTargetInfo GetTargetInfo;
	FInitTargetComms InitTargetComms;
	FEnumerateTargetsEx EnumerateTargetsEx;
	FCloseTargetComms CloseTargetComms;
	FGetDirectoryList GetDirectoryList;
	FProcessLoad ProcessLoad;
	FConnect Connect;
	FRegisterTTYEventHandler RegisterTTYEventHandler;
	FRegisterFTPEventHandler RegisterFTPEventHandler;
	FDisconnect Disconnect;
	FSetTargetInfo SetTargetInfo;
	FReset Reset;
	FResetEx ResetEx;
	FDelete Delete;
	FDownloadFile DownloadFile;
	FMakeDirectory MakeDirectory;
	FUploadFile UploadFile;
	FKick Kick;
	FCancelFTPEvents CancelFTPEvents;
	FCancelTTYEvents CancelTTYEvents;
	FGetPowerStatus GetPowerStatus;
	FGetConnectionStatus GetConnectionStatus;

	FProcessList ProcessList;
	FProcessInfo ProcessInfo;
	FGetGamePortIPAddrData GetGamePortIPAddrData;

	FGetConnectionInfo GetConnectionInfo;
	FSetTimeouts SetTimeouts;
};

#endif // HEADER_SNPS3TMDynamicAPI
