#include <stdio.h>
#include <Windows.h>
#include <xbdm.h>
#include "X360Com.h"
#include "StringHelper.h"

#include "delayimp.h"

#include <string>
using namespace std;

#include <vector>

static bool DelayLoadDll()
{
	DWORD								dwBufferSize(0);
	std::vector<char>		cchEnvironmentBuffer;
	string					strDLLFilename;

	dwBufferSize=GetEnvironmentVariable("XEDK",NULL,0);
	cchEnvironmentBuffer.resize(dwBufferSize+1,0);

	dwBufferSize=GetEnvironmentVariable("XEDK",&cchEnvironmentBuffer.front(),dwBufferSize+1);
	strDLLFilename=&cchEnvironmentBuffer.front();

#if defined(_WIN32)
	strDLLFilename+="\\bin\\win32\\";
#elif defined(_WIN64)
	strDLLFilename+="\\bin\\x64\\";
#else 
	// Not defined.
	_debugbreak();
	return false;
#endif 

	if (FAILED(__HrLoadAllImportsForDll((char *)"xbdm.dll",(char *)strDLLFilename.c_str()))) 
	{
		if (FAILED(__HrLoadAllImportsForDll((char *)"xbdm.dll",(char *)"")))
		{
			return false;
		}
	}
	return true;
}

/*

  CX360Com

*/

CX360Com::CX360Com()
{
}

CX360Com::~CX360Com()
{
}

// IConCom

const char *CX360Com::GetIP()
{
	DWORD address;
	HRESULT hResult = ::DmGetAltAddress(&address);
	if (hResult != XBDM_NOERR)
		return NULL;

	static char ip[16];
	sprintf_s(ip, 16, "%d.%d.%d.%d", 
		((unsigned char *)&address)[3],
		((unsigned char *)&address)[2],
		((unsigned char *)&address)[1],
		((unsigned char *)&address)[0]);
	return ip;
}

bool CX360Com::FileCopyTo(const char *localSource, const char *remoteDestination)
{
	string s;
	size_t offset = 0;
	while (true)
	{
		s = remoteDestination;
		size_t length = Path::GetDirectoryLength(&s[offset]);
		if (!length)
			break;

		offset += length;
		s.clear();
		s.append(remoteDestination, offset);
		::DmMkdir(s.c_str());
	}


	HRESULT hResult = ::DmSendFile(localSource, remoteDestination);
	if (hResult != XBDM_NOERR)
		return false;
	return true;
}

bool CX360Com::FileCopyFrom(const char *remoteSource, const char *localDestination)
{
	string s;
	size_t offset = 0;
	while (true)
	{
		s = localDestination;
		size_t length = Path::GetDirectoryLength(&s[offset]);
		if (!length)
			break;

		offset += length;
		s.clear();
		s.append(localDestination, offset);
		BOOL result=::CreateDirectory(s.c_str(), NULL);
		//::printf("FileCopyFrom() making directory=%s - result=%d\n", s.c_str(), result);
	}

	HRESULT hResult = ::DmReceiveFile(localDestination, remoteSource);
	if (hResult != XBDM_NOERR)
		return false;
	return true;
}


bool CX360Com::Launch(const char* szProgramFullFilename,const char* szWorkingDirectory,unsigned int nArguments,const char** szProgramArguments)
{
	HRESULT hResult(XBDM_NOERR);
	string	strWorkingDir(szWorkingDirectory);
	string	strAppExecutable(szProgramFullFilename);
	string	strArguments;

	::replace_chars(strWorkingDir, '/', '\0');

	for (unsigned int nCount=0;nCount<nArguments;++nCount)
	{
		strArguments+=szProgramArguments[nCount];
		strArguments+=" ";
	}
	
	hResult=::DmSetTitleEx(strWorkingDir.c_str(), strAppExecutable.c_str(), strArguments.c_str(), NULL);
	::DmReboot(DMBOOT_WAIT);

	return (hResult==XBDM_NOERR);
}

/*

  CX360ComManager

*/

CX360ComManager *CX360ComManager::Create()
{
	if (!::DelayLoadDll())
	{
		return NULL;
	}
	return new CX360ComManager();
}

//

CX360ComManager::CX360ComManager()
{
}

CX360ComManager::~CX360ComManager()
{
}

// IConComManager

unsigned int CX360ComManager::GetTargetCount()
{
	return 1;
}

const char *CX360ComManager::GetTargetName(unsigned int index)
{
	if (index)
		return NULL;

	static char buffer[256];
	DWORD length = sizeof(buffer);
	HRESULT hResult = ::DmGetNameOfXbox(buffer, &length, true);
	if (hResult != XBDM_NOERR)
		return NULL;

	return buffer;
} 

IConCom *CX360ComManager::ConnectToTarget(unsigned int index)
{
	return new CX360Com();
}

IConCom *CX360ComManager::ConnectToTargetByName(const char *name)
{
	if (::DmSetXboxNameNoRegister(name) != XBDM_NOERR)
		return NULL;

	return new CX360Com();
}
