#ifndef HEADER_X360Com
#define HEADER_X360Com

#include <Windows.h>
#include "ConCom.h"

class CX360Com :
	public IConCom
{
public:
	CX360Com();
	~CX360Com();

	// IConCom
public:
	virtual void Release() { delete this; }

	virtual const char *GetIP();

	virtual bool FileCopyTo(const char *localSource,const char *remoteDestination=NULL);
	virtual bool FileCopyFrom(const char *remoteSource, const char *localDestination=NULL);

	// For XB360, ,szSelfFullFilename is ignored as they are only needed for PS3.
	virtual bool Launch(const char* szProgramFullFilename,const char* szWorkingDirectory=NULL,unsigned int nArguments=0,const char** szProgramArguments=NULL);
};

class CX360ComManager :
	public IConComManager
{
public:
	static CX360ComManager *Create();

private:
	CX360ComManager();
	~CX360ComManager();

	// IConComManager
public:
	virtual void Release() { delete this; }

	virtual unsigned int GetTargetCount();
	virtual const char *GetTargetName(unsigned int index);

	virtual IConCom *ConnectToTarget(unsigned int index);

	virtual IConCom *ConnectToTargetByName(const char *name);
};

#endif // HEADER_X360Com
