#include <stdio.h>
#include <Windows.h>
#include <xbdm.h>
#include "XB360Com.h"
#include "StringHelper.h"

#include <string>
using namespace std;


/*

  CXB360Com

*/

CXB360Com::CXB360Com()
{
}

CXB360Com::~CXB360Com()
{
}

// IConCom

const char *CXB360Com::GetIP()
{
	DWORD address;
	HRESULT hResult = ::DmGetAltAddress(&address);
	if (hResult != XBDM_NOERR)
		return NULL;

	static char ip[16];
	sprintf_s(ip, 16, "%d.%d.%d.%d", 
		((unsigned char *)&address)[3],
		((unsigned char *)&address)[2],
		((unsigned char *)&address)[1],
		((unsigned char *)&address)[0]);
	return ip;
}

bool CXB360Com::FileCopyTo(const char *localSource, const char *remoteDestination)
{
	string s;
	size_t offset = 0;
	while (true)
	{
		s = remoteDestination;
		size_t length = Path::GetDirectoryLength(&s[offset]);
		if (!length)
			break;

		offset += length;
		s.clear();
		s.append(remoteDestination, offset);
		::DmMkdir(s.c_str());
	}


	HRESULT hResult = ::DmSendFile(localSource, remoteDestination);
	if (hResult != XBDM_NOERR)
		return false;
	return true;
}

/*

  CXB360ComManager

*/

CXB360ComManager *CXB360ComManager::Create()
{
	return new CXB360ComManager();
}

//

CXB360ComManager::CXB360ComManager()
{
}

CXB360ComManager::~CXB360ComManager()
{
}

// IConComManager

unsigned int CXB360ComManager::GetTargetCount()
{
	return 1;
}

const char *CXB360ComManager::GetTargetName(unsigned int index)
{
	if (index)
		return NULL;

	static char buffer[256];
	DWORD length = sizeof(buffer);
	HRESULT hResult = ::DmGetNameOfXbox(buffer, &length, true);
	if (hResult != XBDM_NOERR)
		return NULL;

	return buffer;
}

IConCom *CXB360ComManager::ConnectToTarget(unsigned int index)
{
	return new CXB360Com();
}
