#ifndef HEADER_XB360Com
#define HEADER_XB360Com

#include <Windows.h>
#include "ConCom.h"

class CXB360Com :
	public IConCom
{
public:
	CXB360Com();
	~CXB360Com();

	// IConCom
public:
	virtual void Release() { delete this; }

	virtual const char *GetIP();

	virtual bool FileCopyTo(const char *localSource, const char *remoteDestination);
};

class CXB360ComManager :
	public IConComManager
{
public:
	static CXB360ComManager *Create();

private:
	CXB360ComManager();
	~CXB360ComManager();

	// IConComManager
public:
	virtual void Release() { delete this; }

	virtual unsigned int GetTargetCount();
	virtual const char *GetTargetName(unsigned int index);

	virtual IConCom *ConnectToTarget(unsigned int index);
};

#endif // HEADER_XB360Com
