#include "stdafx.h"

#include "delayimp.h"
#include "Include/IEditorClassFactory.h"
#include "Include/IConsoleConnectivity.h"
#include "XBOX360ConsoleConnectivity.h"
#include "Winsock2.h"

// HACK to link correctly... as we won't use this pointer anyway here,
// no problem if it's null and allow us to link stuff.
struct SSystemGlobalEnvironment * gEnv(NULL);

static bool DelayLoadDll()
{
	DWORD								dwBufferSize(0);
	std::vector<char>		cchEnvironmentBuffer;
	string					strDLLFilename;

	dwBufferSize=GetEnvironmentVariable("XEDK",NULL,0);
	cchEnvironmentBuffer.resize(dwBufferSize+1,0);

	dwBufferSize=GetEnvironmentVariable("XEDK",&cchEnvironmentBuffer.front(),dwBufferSize+1);
	strDLLFilename=&cchEnvironmentBuffer.front();

#if defined(_WIN32)
	strDLLFilename+="\\bin\\win32\\";
#elif defined(_WIN64)
	strDLLFilename+="\\bin\\x64\\";
#else 
	// Not defined.
	_debugbreak();
	return false;
#endif 

	if (FAILED(__HrLoadAllImportsForDll((char *)"xbdm.dll",(char *)strDLLFilename.c_str()))) 
	{
		return false;
	}
	return true;
}

bool CommandLineDispatcher(int argc, char* argv[])
{
	// Warns about too many arguments.
	if (argc>1)
	{
		if (stricmp(argv[1],"copytoconsole")==0)
		{
			// if it's not a copy to console, it's incorrect usage.
			if (argc!=4)
			{
				printf("Invalid number of arguments for command copytoconsole.\nUsage: copytoconsole \"sourcefile\" \"targetfile\".\n Hint: surround paths with \"\".\n");
			}
			else
			{
				CXBOX360ConnectivityPlugin oConnectivityPlugin;
				if (oConnectivityPlugin.SendFile(argv[2],argv[3]))
				{
					printf("Copy to console succeeded.\n");
				}
				else
				{
					printf("Copy to console failed.\n");
				}
			}
		}
		else if (stricmp(argv[1],"notifyfilechange")==0)
		{
			if (argc!=3)
			{
				printf("Invalid number of arguments for command notifyfilechange.\nUsage: xboxconnectivity notifyfilechange \"targetpath\".\n Hint: surround path with \"\".\n");
			}
			else
			{
				CXBOX360ConnectivityPlugin oConnectivityPlugin;
				if (oConnectivityPlugin.NotifyFileChange(argv[2]))
				{
					printf("Notify file change succeeded.\n");
				}
				else
				{
					printf("Notify file change failed.\n");
				}
			}
		}
		else if (stricmp(argv[1],"checkconnection")==0)
		{
			// Check connection and ignore any other possible argument.
			CXBOX360ConnectivityPlugin  oConnectivityPlugin;
			if (oConnectivityPlugin.IsConnectedToConsole())
			{
				printf("Check connection succeeded.\n");
			}
			else
			{
				printf("Check connection failed.\n");
			}
		}
		else if (stricmp(argv[1],"getaddress")==0)
		{
			// Check connection and ignore any other possible argument.
			CXBOX360ConnectivityPlugin  oConnectivityPlugin;
			DWORD												dwConsoleAddress(0);

			if (!oConnectivityPlugin.GetConsoleAddress(&dwConsoleAddress))
			{
				printf("failed\n");
			}
			else
			{
				in_addr			sInputAddress;
				sInputAddress.S_un.S_addr=dwConsoleAddress;
				printf("succeeded:%s\n",inet_ntoa(sInputAddress));
			}			
		}
		else  if (stricmp(argv[1],"help")==0)
		{
			// Call help and ignore any other possible argument.
			printf("Usage:\n XBOXConnectivity command parameters\n Available commands:\n - copytoconsole\n - notifyfilechange\n - checkconnection\n - getaddress\n - help\nExample usage:\n XBoxConnectivity copytoconsole \"my source path\\my source file.pak\" \"my target path\\ \" \n \n XBoxConnectivity copytoconsole \"my source path\\my source file.dds\" \"my target path\\mytargetfile.dds \" \n XBoxConnectivity notifyfilechange \"xE:\\CryEngine\\Changefile.cfg\"\n");
		}
		else
		{
			// Call help and ignore any other possible argument.
			printf("Unknown command.\nUsage:\n XBOXConnectivity command parameters\n Available commands:\n - copytoconsole\n - notifyfilechange\n - checkconnection\n - getaddress\n - help\nExample usage:\n XBoxConnectivity copytoconsole \"my source path\\my source file.pak\" \"my target path\\ \" \n \n XBoxConnectivity copytoconsole \"my source path\\my source file.dds\" \"my target path\\mytargetfile.dds \" \n XBoxConnectivity notifyfilechange \"xE:\\CryEngine\\Changefile.cfg\"\n");
			// Unknown command, report error and call help.
		}
	}
	else
	{
		printf("Usage:\n XBOXConnectivity command parameters\n Available commands:\n XBOXConnectivity command parameters\n Available commands:\n - copytoconsole\n - notifyfilechange\n - checkconnection\n - getaddress\n - help\nExample usage:\n XBoxConnectivity copytoconsole \"my source path\\my source file.pak\" \"my target path\\ \" \n \n XBoxConnectivity copytoconsole \"my source path\\my source file.dds\" \"my target path\\mytargetfile.dds \" \n XBoxConnectivity notifyfilechange \"xE:\\CryEngine\\Changefile.cfg\"\n");
	}

	return true;
}

// Added here to prevent link errors.
void *CryModuleMalloc(size_t nSize)
{
	return malloc(nSize);
}

// Added here to prevent link errors.
size_t CryModuleFree(void* pInput)
{
	free(pInput);
	// This is a REAL lie, it will always return the number of bytes needed
	// to store a void pointer.
	return sizeof(pInput);
}

int main(int argc, char* argv[])
{
	if (!DelayLoadDll())
	{
		return -1;
	}

	CommandLineDispatcher(argc,argv);

	return 0;
}
