#!/bin/bash
# The comment in this file are needed, the bash file would show errors when \r is found
echo "----------Changing error.log date------------"
currentDate=`date +%s` #
echo "$currentDate"
#
# replace in files called error.log lines like:
#1) namespace::<number>
# with a different number (taken from the timestamp)
# then replace multiple occurrences of \r (the $currentDate variables for instance have newlines in it) 
# then replace each line in order to have \r\n at the end
#
find . -iname error.log -exec sed -i.bak -e "s/^\([0-9]*) [^:]*::\)\([0-9][0-9]*\)\(.*\)$/\1$currentDate\3/" -e "s/\([0-9]\)\r*(/\1(/g" -e "s/^\(.*\)$/\1\r/" {} \; -print #don't remove this comment
#
# Changing the build time for jiraSettingsFuture (
#
echo "---------------------END-----------------------"
echo #
echo #
echo "-------Setting date for FutureGame.log---------"
buildTimeDate=`date --date "now +1 months" "+%b %e %Y %T"`
echo "$buildTimeDate"
find . -iname futuregame.log -exec sed -i.bak -e "s/^BuildTime: .*$/BuildTime: $buildTimeDate/" -e "s/\r//g"  {} \; -print #don't remove this comment 
echo "---------------------END-----------------------"
echo #
echo #
#
#
#
echo "-------Setting date for XboxNew.log---------"
dateInHex=`printf '%08X' $currentDate` #
find . -name XboxNew.log -exec sed -i.bak -e "s/^\(\s*[0-9]*)\s*\).*$/\1$dateInHex/" -e "s/\r//g"  {} \; -execdir cp -f XboxNew.log error.log \; -print #don't remove this comment 
echo "---------------------END-----------------------"
echo #
echo #
#
#
#
#
echo "----Resetting modified time for XboxPackets----"
find ./XboxCrashHandlerFiles/ -name *.log -exec touch --date "now +1 months" {} \; -exec sleep 2 \; -print #
echo "---------------------END-----------------------"
echo #
echo #
#
#
#
echo "-------- Resetting packet2 datetimes ----------"
find ./XboxCrashHandlerFiles/ -name GamePacket2a.log -exec touch -t 200001010101 {} \; -print #
find ./XboxCrashHandlerFiles/ -name GamePacket2b.log -exec touch -t 203801010101 {} \; -print #
echo "---------------------END-----------------------"
#
