using System;
using System.IO;
using System.Windows.Forms;

namespace CrashHandler
{
    public class Log
    {
        string m_logPath;
        LogListener m_listener;

        public Log(String logFolder, Settings setting){
            m_logPath = Path.Combine(logFolder, setting.LogFileName);
            File.Delete(m_logPath);
        }

        public void SetListener(LogListener listener)
        {
            m_listener = listener;
        }

        public void Info(string message)
        {
            System.Diagnostics.Debug.WriteLine(message);
            try
            {
                if (m_listener != null)
                {
                    m_listener.SetStatus(message);
                }

                if(m_logPath != null){
                // using statement forces the file to be disposed and closed at the end of scope
                    using (StreamWriter s = File.AppendText(m_logPath))
                    {
                        s.WriteLine(message);
                    }
                } else {
                    System.Diagnostics.Debug.WriteLine("Couldn't write to log file: the m_logPath is null");
                }
            }
            catch (Exception ex)
            {
                string errorMessage = "Couldn't write to log file: " + ex.Message;
                System.Console.Out.WriteLine(errorMessage);
                System.Diagnostics.Debug.WriteLine(errorMessage);
            }
        }

        public void Warn(String message)
        {
            Info("[Warning] " + message);
        }

        public void Popup(string message)
        {
            Info(message);
            if (m_listener != null)
            {
                m_listener.WarnUser(message);
            }
            else
            {
                MessageBox.Show(message);
            }
        }

        public string LogPath { get { return m_logPath; } }
    }
}
