using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace CrashHandler.UI
{
    public partial class Common : Form, LogListener
    {
        
        public Common()
        {
            InitializeComponent();

            String imageLocation = Application.StartupPath + "\\background.jpg";
            if (File.Exists(imageLocation))
            {
                this.BackgroundImage = System.Drawing.Image.FromFile(imageLocation);
                this.BackgroundImageLayout = System.Windows.Forms.ImageLayout.None;
            }
        }

        void LogListener.SetStatus(string status)
        {
            string firstLine = status;
            const int MAX_LOG_LINES = 15;
            if(status.Contains(Environment.NewLine))
            {
                firstLine = status.Substring(0, status.IndexOf(Environment.NewLine));
            }
            statusLabel.Text = firstLine;
            logTrace.Invoke(new MethodInvoker(
                delegate {
                    logTrace.Text += status + Environment.NewLine;
                    String[] currentTraceText = logTrace.Text.Split('\n');
                    if(currentTraceText.Length > MAX_LOG_LINES){
                        logTrace.Text = String.Join("\n", currentTraceText, currentTraceText.Length - MAX_LOG_LINES, MAX_LOG_LINES);
                    } 
                }));
        }

        void LogListener.WarnUser(String message)
        {
            this.Invoke(new MethodInvoker(
                delegate
                {
                    MessageBox.Show(this, message);
                    if (pagePanel.Controls.Count > 0)
                    {
                        Control currentControl = pagePanel.Controls[0];
                        if (currentControl.GetType() == typeof(EditCrashDetail))
                        {
                            ((EditCrashDetail)currentControl).SetWarningMessage(message);
                        }
                    }
                }));
        }

        public void SetContents(Control control)
        {
            pagePanel.Controls.Clear();
            pagePanel.Controls.Add(control);
        }


    }
}
