#include "DebugHelper.h"
#include <DbgHelp.h>
#include <Winbase.h>
using namespace DebugHelper;
#pragma comment( lib, "dbghelp.lib" )

namespace
{
	void FreeConvertedString(char* str)
	{
		System::Runtime::InteropServices::Marshal::FreeHGlobal((IntPtr)str);
	}

	char* ConvertString(String^ str)
	{
		return (char*)(void*) System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(str);
	}

	static GUID ConvertByteArrayToGuid(Guid^ guid)
	{
		GUID result;
		cli::array<System::Byte>^ guidData = guid->ToByteArray();
		result.Data1 = BitConverter::ToUInt32(guidData, 0);
		result.Data2 = BitConverter::ToInt16(guidData, 4);
		result.Data3 = BitConverter::ToInt16(guidData, 6);
		for(int index = 0; index < 8; ++index){
			result.Data4[index] = guidData[index + 8];
		}
		return result;

	}

}

SymbolServer::SymbolServer(String^ symbolSearchPath)
{
	// Enable DbgHelp debug messages, make sure that DbgHelp only loads symbols that
	// exactly match, and do deferred symbol loading for greater efficiency.
	SymSetOptions( SYMOPT_DEBUG | SYMOPT_EXACT_SYMBOLS | SYMOPT_DEFERRED_LOADS );
	m_currentProcessHandler = GetCurrentProcess();

	char* fullPath = ConvertString(symbolSearchPath);
	BOOL result = SymInitialize( m_currentProcessHandler, fullPath, FALSE);
	FreeConvertedString(fullPath);
}

bool^ SymbolServer::FindFileInPath(String^ path, Guid^ guid, long age, String^% foundPath)
{
	char resultPath[2000];
	char* pdbFilepath = ConvertString(path);
	GUID guidWrap= ConvertByteArrayToGuid(guid);

	bool result = (SymFindFileInPath(m_currentProcessHandler, 0, pdbFilepath , &guidWrap, age, 0, SSRVOPT_GUIDPTR, resultPath, NULL, NULL)==TRUE);
	
	foundPath = gcnew String(resultPath);
	FreeConvertedString(pdbFilepath);
	return result;

}
SymbolServer::~SymbolServer()
{
	SymCleanup(m_currentProcessHandler);
}
