package com.crytek.jira.plugins.crashHandler;

import java.util.Date;

import com.atlassian.jira.rpc.exception.RemoteAuthenticationException;
import com.atlassian.jira.rpc.exception.RemoteException;

public interface CrashHandlerSoapService
{
	/**
	 * This will authenticate the user in JIRA and returned a authentication
	 * token that can then be used on all other SOAP methods.
	 * 
	 * @param username
	 *            the JIRA user name to authenticate
	 * @param password
	 *            the password of the JIRA user
	 * @return a authentication token that can then be used on further SOAP
	 *         calls.
	 * @throws RemoteException
	 *             If there was some problem preventing the operation from
	 *             working.
	 * @throws RemoteAuthenticationException
	 *             If the username and password is an invalid combination
	 */
	String crashHandlerLogin(String username, String password) throws RemoteException, RemoteAuthenticationException;

	/**
	 * Returns any matching issues for the provided call stack.
	 * 
	 * @param token
	 *            the SOAP authentication token.
	 * @param project
	 *            the project in which to look for matches (null for all
	 *            projects)
	 * @param errorLogContents
	 *            error log file contents
	 * @param summary
	 *            the issue summary
	 * @param description
	 *            the issue description
	 * @param reporter
	 *            the issue reporter
	 * @param assignee
	 *            the default issue assignee
	 * @param buildNumber
	 *            the build number
	 * @param platform
	 *            the platform
	 * @return the matching RemoteIssue for the call stack (which this method
	 *         may create)
	 * @throws RemoteException
	 *             If there was some problem preventing the operation from
	 *             working.
	 */

	public JiraCrashInfo registerCrash(String token, String project, String errorLogContents, String issueType, String summary, String description,
			String reporter, String assignee, String buildNumber, Date buildTime, String platform) throws Exception;
}