package com.crytek.jira.plugins.crashHandler;

import java.util.Date;

import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.rpc.auth.TokenManager;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.soap.service.IssueService;
import com.opensymphony.user.User;

public class CrashHandlerSoapServiceImpl implements CrashHandlerSoapService
{
	private final TokenManager tokenManager;
	private final IssueLinkTypeManager issueLinkTypeManager;
	private final IssueService issueService;

	public CrashHandlerSoapServiceImpl(IssueService issueService, IssueLinkTypeManager issueLinkTypeManager, TokenManager tokenManager)
	{
		this.tokenManager = tokenManager;
		this.issueLinkTypeManager = issueLinkTypeManager;
		this.issueService = issueService;

	}

	public String crashHandlerLogin(String username, String password) throws RemoteException
	{
		return tokenManager.login(username, password);
	}

	public JiraCrashInfo registerCrash(String token, String project, String errorLogContents, String issueType, String summary, String description,
			String reporter, String assignee, String buildNumber, Date buildTime, String platform) throws Exception
	{
		try
		{
			User user = tokenManager.retrieveUserNoPermissionCheck(token);
			// TODO: pass typed parameters for assignee and for project (one can
			// be taken using the token manager, the other one from
			// ComponentManager.getInstance().getProjectManager().getProjectObjByName(arg0);
			CrashMatcher crashMatcher = new CrashMatcher(issueService, issueLinkTypeManager);
			return crashMatcher.registerCrash(user, project, errorLogContents, issueType, summary, description, reporter, assignee, buildNumber, buildTime,
					platform);
		}
		catch (Throwable e)
		{
			ExceptionHelper.sendErrorEmail("An error occurred in the crash handler jira plugin", e);
			throw new RemoteException(e);
		}
	}
}
