package com.crytek.jira.plugins.crashHandler;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.onresolve.jira.crytek.settings.Settings;

public class ExceptionHelper
{

	final static String appendToLines = "* ";

	// TODO: perhaps add different types of exception that can be sent,
	// application exception, non fatal exception etc..
	// TODO: convert it to a singleton once the tests are setup
	public static void sendErrorEmail(String messageBody)
	{
		Settings settings = Settings.getSettings();
		String[] recipients = settings.getMaintainersEmail().split(";");
		for (int index = 0; index < recipients.length; ++index)
		{
			Email email = new Email(recipients[index]);
			email.setFrom(settings.getEmailFrom());
			email.setSubject(settings.getEmailSubject());
			email.setBody(messageBody);
			sendEmail(email);
		}
	}

	private static void sendEmail(Email email)
	{
		SingleMailQueueItem item = new SingleMailQueueItem(email);
		item.setMailThreader(null);
		ManagerFactory.getMailQueue().addItem(item);
	}

	public static void sendErrorEmail(String message, Throwable e)
	{
		final String separator = Utils.newLine + Utils.newLine + Utils.newLine;
		StringBuilder builder = new StringBuilder(message);

		builder.append(separator);

		builder.append("Exception message: ");
		builder.append(e.getMessage());
		builder.append(separator);

		builder.append(appendToLines);
		builder.append("Exception Call Stack: ");
		builder.append(Utils.newLine);
		appendStackInfo(builder, e);

		sendErrorEmail(builder.toString());

	}

	private static void appendStackInfo(StringBuilder builder, Throwable e)
	{
		StackTraceElement[] stackLines = e.getStackTrace();

		if (stackLines != null)
		{
			for (StackTraceElement stackLine : stackLines)
			{
				builder.append(appendToLines);
				builder.append(stackLine.toString());
				builder.append(Utils.newLine);
			}
		}
	}

}
