package com.crytek.jira.plugins.crashHandler;

import com.atlassian.jira.rpc.soap.beans.RemoteIssue;

public class JiraCrashInfo
{
	// enum can't be passed through the wsdl (at least java enums cannot be
	// parsed properly from the wsld.exe) this is the best way to do this :(
	public static final String Create = "Create";
	public static final String Reopen = "Reopen";
	public static final String Ignore = "Ignore";
	public static final String FixedInNewerBuild = "FixedInNewerBuild";
	public static final String Comment = "Comment";

	private RemoteIssue issue;
	private final String actionPerformed;
	private int crashCount;

	public JiraCrashInfo(RemoteIssue issue, String actionPerformed)
	{
		this.issue = issue;
		this.actionPerformed = actionPerformed;
	}

	public JiraCrashInfo(RemoteIssue issue, String actionPerformed, int crashCount)
	{
		this.issue = issue;
		this.actionPerformed = actionPerformed;
		this.crashCount = crashCount;
	}

	public void setIssue(RemoteIssue issue)
	{
		this.issue = issue;
	}

	public String getActionPerformed()
	{
		return actionPerformed;
	}

	public RemoteIssue getIssue()
	{
		return issue;
	}

	public void setCrashCount(int crashCount)
	{
		this.crashCount = crashCount;
	}

	public int getCrashCount()
	{
		return crashCount;
	}

}
