package com.crytek.jira.plugins.crashHandler;

import java.util.List;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.opensymphony.user.User;

public class JiraSearch
{

	private final SearchProvider searchProvider;
	private static final String callStackHeader = "\"Call Stack Trace:\"";

	public JiraSearch()
	{
		this.searchProvider = ComponentManager.getInstance().getSearchProvider();
	}

	private List<Issue> getByQueryStringField(User user, String callStackHeader) throws SearchException
	{
		JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
		builder.where().description().like(callStackHeader).or().comment().like(callStackHeader);
		Query query = builder.buildQuery();
		List<Issue> rawIssues = searchProvider.search(query, user, PagerFilter.getUnlimitedFilter()).getIssues();
		return rawIssues;
	}

	public Issue[] getAllCrashes(User user) throws Exception
	{
		List<Issue> rawIssues = getByQueryStringField(user, callStackHeader);

		Issue[] result = new Issue[rawIssues.size()];
		rawIssues.toArray(result);
		return result;
	}
}
