package com.crytek.jira.plugins.crashHandler;

public class SignatureInfo
{

	public static final String CALL_STACK_VERSION_ID_LINE_HEADER = "Version#:";
	public static final String EXCEPTION_DESCRIPTION_LINE_HEADER = "Exception Description:";
	public static final String SIGNATURE_LINE_HEADER = "Signature:";
	public static final String CALL_STACK_SEPARATOR = " ";

	private final int callStackVersionId;
	private final String signature;
	private final String exceptionDescription;

	public SignatureInfo(int callStackVersionId, String exceptionDescription, String signature)
	{
		this.callStackVersionId = callStackVersionId;
		this.exceptionDescription = exceptionDescription;
		this.signature = signature;
	}

	public int getCallStackVersionId()
	{
		return callStackVersionId;
	}

	public String getSignature()
	{
		return signature;
	}

	public String getExceptionDescription()
	{
		return exceptionDescription;
	}

	public String[] getCrashSignatureLines()
	{
		if (signature == null || signature.trim().equals(""))
		{
			return new String[] {};
		}
		return signature.trim().split(CALL_STACK_SEPARATOR);
	}

	public String getIssueSignature()
	{
		StringBuilder builder = new StringBuilder(CALL_STACK_VERSION_ID_LINE_HEADER);
		builder.append(callStackVersionId);
		builder.append(Utils.newLine);
		builder.append(EXCEPTION_DESCRIPTION_LINE_HEADER);
		builder.append(exceptionDescription);
		builder.append(Utils.newLine);
		builder.append(SIGNATURE_LINE_HEADER);
		builder.append(signature);
		return builder.toString();

	}

}
