package com.crytek.jira.plugins.crashHandler;

import java.util.Collection;

import com.atlassian.jira.ComponentManager;
import com.opensymphony.user.User;

public class Utils
{
	public static final double epsilon = 0.000001; // rounding error
	public static final String newLine = System.getProperty("line.separator");

	public static boolean equals(double a, double b)
	{

		return Math.abs(a - b) < epsilon;
	}

	public static boolean greaterThan(double a, double b)
	{
		return a > b && !equals(a, b);
	}

	public static boolean lessThan(double a, double b)
	{
		return a < b && !equals(a, b);
	}

	public static String[] splitInLines(String text)
	{
		return text.split("\r*\n\r*");
	}

	public static User getAdministator()
	{
		@SuppressWarnings("unchecked")
		Collection users = ComponentManager.getInstance().getUserUtil().getAdministrators();
		if (users == null || users.isEmpty())
		{
			throw new NullPointerException();
		}
		return (User) users.iterator().next();
	}

}
