package com.crytek.jira.plugins.crashHandler.signature;

import com.crytek.jira.plugins.crashHandler.SignatureInfo;
import com.onresolve.jira.crytek.settings.Settings;

public enum ComparerFactory
{
	PREFIX_COMPARER(PrefixComparer.class, "Prefix comparer", "Match two callstacks checking from the first line to the bottom"),
	EDIT_DISTANCE_COMPARER(EditDistanceComparer.class, "Edit distance comparer",
			"Match two callstack depending on how many edit, add and deletes are needed to transform the first callstack to the second"),
	OPTIMIZED_EDIT_DISTANCE_COMPARER(OptimizedEditDistanceComparer.class, "Optimized edit distance",
			"Match two callstack depending on how many edit, add and deletes are needed to transform the first callstack to the second, it's optimized in terms of memory"),
	DISTANCE_WEIGHTED_EDIT_COMPARER(DistanceWeightedEditComparer.class, "Distance weighted",
			"Match two callstack depending on the edit distance and the position where two callstack lines are located"),
	DISTANCE_WEIGHTED_EXCLUSION_EDIT_COMPARER(DistanceWeightedExclusionEditComparer.class, "Distance weighted edit with exclusion",
			"Distance weighted comparer where the first two lines have to be equal");

	private ComparerFactory(Class<? extends AbstractCallStackComparer> objectType, String name, String description)
	{
		this.objectToInstantiate = objectType;
		this.name = name;
		this.description = description;
	}

	public String getClassName()
	{
		return this.objectToInstantiate.getName();
	}

	public String getName()
	{
		return name;
	}

	public String getDescription()
	{
		return this.description;
	}

	public AbstractCallStackComparer get(SignatureInfo callstack)
	{
		Settings currentSettings = Settings.getSettings();
		switch (this)
		{
		case PREFIX_COMPARER:
			return new PrefixComparer(callstack);
		case EDIT_DISTANCE_COMPARER:
			return new EditDistanceComparer(callstack);
		case OPTIMIZED_EDIT_DISTANCE_COMPARER:
			return new OptimizedEditDistanceComparer(callstack, currentSettings);
		case DISTANCE_WEIGHTED_EDIT_COMPARER:
			return new DistanceWeightedEditComparer(callstack, currentSettings);
		case DISTANCE_WEIGHTED_EXCLUSION_EDIT_COMPARER:
			return new DistanceWeightedExclusionEditComparer(callstack, currentSettings);
		default:
			return new PrefixComparer(callstack);
		}
	}

	private Class<? extends AbstractCallStackComparer> objectToInstantiate;
	private String name;
	private String description;

}
