package com.crytek.jira.plugins.crashHandler.signature;

import com.crytek.jira.plugins.crashHandler.SignatureInfo;

//I implemented the pure edit distance instead of bartzM2 because the weights are not working properly.. need to know the gustfield method
// https://www.usenix.org/events/sysml08/tech/full_papers/bartz/bartz_html/
public class EditDistanceComparer extends AbstractCallStackComparer
{
	private final String[] callStackLines;

	public EditDistanceComparer(SignatureInfo currentSignature)
	{
		callStackLines = currentSignature.getCrashSignatureLines();
	}

	@Override
	public double rateSimilarity(SignatureInfo signature)
	{
		String[] otherCallStackLines = signature.getCrashSignatureLines();
		if (callStackLines.length == 0 || otherCallStackLines.length == 0)
		{
			return 0;
		}
		int maxSize = Math.max(callStackLines.length, otherCallStackLines.length);

		double editDistance = levenshteinDistance(otherCallStackLines);
		return 1d - (editDistance / maxSize);
	}

	/**
	 * Levenshtein algorithm, calculates the number of changes needs to be made
	 * to transform string 1 in string 2 in this case we are comparing the lines
	 * in the call stack instead of characters.
	 * http://en.wikipedia.org/wiki/Levenshtein_distance
	 * 
	 * The higher the result the more the two strings are different
	 * 
	 * @param otherCallStackLines
	 * @return the number of changes (insert, delete substitution) that needs
	 *         make in order to change the first call stack in the second
	 */
	public double levenshteinDistance(String[] otherCallStackLines)
	{
		int otherLength = otherCallStackLines.length + 1;
		int myLength = callStackLines.length + 1;
		double[][] editDistance = new double[otherLength][myLength];

		initCurrentCallStackHeading(editDistance);

		initOtherCallStackHeading(editDistance);

		for (int myIndex = 1; myIndex < myLength; ++myIndex)
		{
			for (int otherIndex = 1; otherIndex < otherLength; ++otherIndex)
			{
				double cost;
				if (callStackLines[myIndex - 1].equals(otherCallStackLines[otherIndex - 1]))
				{
					cost = 0;
				}
				else
				{
					cost = 1;
				}
				double insertion = editDistance[otherIndex - 1][myIndex] + 1;
				double deletion = editDistance[otherIndex][myIndex - 1] + 1;
				double edit = editDistance[otherIndex - 1][myIndex - 1] + cost;

				editDistance[otherIndex][myIndex] = Math.min(edit, Math.min(insertion, deletion));
			}
		}

		return editDistance[otherLength - 1][myLength - 1];
	}

	private void initOtherCallStackHeading(double[][] table)
	{
		int lengthOther = table[0].length;
		for (int index = 0; index < lengthOther; ++index)
		{
			table[0][index] = index;
		}
	}

	private void initCurrentCallStackHeading(double[][] table)
	{
		int lengthCurrent = table.length;
		for (int index = 0; index < lengthCurrent; ++index)
		{
			table[index][0] = index;
		}
	}
}
