package com.crytek.jira.plugins.crashHandler.signature;

import com.crytek.jira.plugins.crashHandler.SignatureInfo;

public class PrefixComparer extends AbstractCallStackComparer
{
	private final String[] callStackLines;

	public PrefixComparer(SignatureInfo signatureInfo)
	{
		callStackLines = signatureInfo.getCrashSignatureLines();
	}

	// see http://db.uwaterloo.ca/tcde-smdb/smdb07slides/LohmanSMDBWorkshop.ppt
	@Override
	public double rateSimilarity(SignatureInfo otherSignature)
	{
		if (callStackLines.length == 0)
		{
			return 0;
		}
		String[] crashSignature2 = otherSignature.getCrashSignatureLines();
		int minCrashSignatureLength = Math.min(callStackLines.length, crashSignature2.length);
		int maxCrashSignatureLength = Math.max(callStackLines.length, crashSignature2.length);
		int matchingLineCount = 0;

		for (int line = 0; line < minCrashSignatureLength; ++line)
		{
			if (callStackLines[line].equals(crashSignature2[line]))
			{
				++matchingLineCount;
			}
			else
			{
				break;
			}
		}

		double score = (double) matchingLineCount / (double) maxCrashSignatureLength;
		return score;
	}
}
