package com.onresolve.jira.crytek.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.jira.workflow.WorkflowManager;
import com.crytek.jira.plugins.crashHandler.ExceptionHelper;
import com.crytek.jira.plugins.crashHandler.Utils;
import com.crytek.jira.plugins.crashHandler.signature.ComparerFactory;

public class CrashHandlerSettingsPage extends IssueActionSupport
{
	// TODO: Add validation
	/**
	 * Generated SerialVersionUID
	 **/
	private static final long serialVersionUID = 4263397787152740280L;

	private boolean formSubmitted;
	private Settings settings;
	private boolean restoreDefaults;

	// Entry point.
	@Override
	protected String doExecute() throws Exception
	{
		if (getRestoreDefaults())
		{
			return restoreDefault();
		}
		if (!getFormSubmitted())
		{
			return doDefault();
		}
		String pageType = super.doExecute();
		Settings.saveSettings(settings);
		settings = Settings.getSettings();

		return pageType;
	}

	// Entry point. this page can be accessed by
	// /secure/admin/jira/crytek/settings/CrytekCrashHandler!Restore.jspa
	public String doRestore() throws Exception
	{
		Settings.deleteSettings();
		settings = Settings.getSettings();
		return super.doExecute();
	}

	private String restoreDefault() throws Exception
	{
		settings = Settings.getDefaultSettings();
		Settings.saveSettings(settings);
		settings = Settings.getSettings();
		return super.doExecute();
	}

	public CrashHandlerSettingsPage()
	{
		formSubmitted = false;
		restoreDefaults = false;
		try
		{
			settings = Settings.getSettings();
		}
		catch (Exception e)
		{
			settings = Settings.getDefaultSettings();
		}
	}

	public List<String> getAllIssueStatus()
	{
		Collection<Status> statuses = ComponentManager.getInstance().getConstantsManager().getStatusObjects();
		ArrayList<String> result = new ArrayList<String>();
		for (Status status : statuses)
		{
			result.add(status.getName());
		}
		Collections.sort(result);
		return result;

	}

	public List<String> getAllCustomField()
	{
		List<CustomField> customFieldObjects = ComponentManager.getInstance().getCustomFieldManager().getCustomFieldObjects();
		List<String> result = new ArrayList<String>();
		for (CustomField customField : customFieldObjects)
		{
			result.add(customField.getName());
		}
		return result;
	}

	public String[] getAllAvailableActions()
	{
		// the hashSet is used in order to eliminate duplicated elements;
		HashSet<String> data = new HashSet<String>();

		try
		{
			WorkflowManager workflowManager = ComponentManager.getInstance().getWorkflowManager();
			@SuppressWarnings("unchecked")
			Collection workflowNames = ComponentManager.getInstance().getWorkflowSchemeManager().getActiveWorkflowNames();
			for (Object oName : workflowNames)
			{
				String name = oName.toString();
				@SuppressWarnings("unchecked")
				Collection actions = workflowManager.getWorkflow(name).getAllActions();
				for (Object oAction : actions)
				{
					// certain actions have (fieldscreen) against them, it's
					// probably a jira internal thing so it's better to remove
					// it
					data.add(oAction.toString().replaceAll("\\s*\\((fieldscreen|commentassign|resolveissue)\\)", ""));
				}
			}
		}
		catch (Exception e)
		{
			ExceptionHelper.sendErrorEmail("an error occurred in getAllAvailableActions, for the setting page ", e);
		}

		String[] result = new String[data.size()];
		data.toArray(result);
		Arrays.sort(result);
		return result;
	}

	public ComparerFactory[] getAllComparers()
	{
		return ComparerFactory.values();
	}

	public List<Priority> getAllPriorities()
	{
		Collection<Priority> priorities = ComponentManager.getInstance().getConstantsManager().getPriorityObjects();
		List<Priority> result = new ArrayList<Priority>(priorities);

		Collections.sort(result, getPrioritiesComparator());
		return result;
	}

	private static Comparator<Priority> getPrioritiesComparator()
	{
		return new Comparator<Priority>()
		{
			public int compare(Priority aPriority, Priority anotherPriority)
			{
				return aPriority.getName().compareTo(anotherPriority.getName());
			}
		};
	}

	public boolean getRestoreDefaults()
	{
		return restoreDefaults;
	}

	public void setRestoreDefaults(boolean restoreDefaults)
	{
		this.restoreDefaults = restoreDefaults;
	}

	public boolean getFormSubmitted()
	{
		return formSubmitted;
	}

	public Settings getSettings()
	{
		return settings;
	}

	public void setFormSubmitted(boolean value)
	{
		formSubmitted = value;
	}

	// TODO: find a way to map form values directly to the Setting object(should
	// be possible setting "name" the input fields with something like
	// "settings.maintainersEmail" but doesn't work in practice :/
	public String getMaintainersEmail()
	{
		return settings.getMaintainersEmail();
	}

	public void setMaintainersEmail(String maintainersEmail)
	{
		settings.setMaintainersEmail(maintainersEmail);
	}

	public String getEmailFrom()
	{
		return settings.getEmailFrom();
	}

	public void setEmailFrom(String emailFrom)
	{
		settings.setEmailFrom(emailFrom);
	}

	public String getEmailSubject()
	{
		return settings.getEmailSubject();
	}

	public void setEmailSubject(String emailSubject)
	{
		settings.setEmailSubject(emailSubject);
	}

	public List<String> getOpenIssueStatuses()
	{
		return settings.getOpenIssueStatuses();
	}

	// these as String methods are made in order to make it do the correct
	// binding..
	public void setOpenIssueStatusesAsString(String openIssueStatuses)
	{
		settings.setOpenIssueStatuses(toList(openIssueStatuses));
	}

	public List<String> getFixedIssueStatuses()
	{

		return settings.getFixedIssueStatuses();
	}

	public String getPriorityId()
	{
		return settings.getPriorityId();
	}

	public void setPriorityId(String priority)
	{
		settings.setPriorityId(priority);
	}

	public void setFixedIssueStatusesAsString(String fixedActions)
	{
		settings.setFixedIssueStatuses(toList(fixedActions));
	}

	public List<String> getOpenActions()
	{
		return settings.getOpenActions();
	}

	public void setOpenActionsAsString(String openActions)
	{
		settings.setOpenActions(toList(openActions));
	}

	public Integer getHoursDifference()
	{
		return settings.getHoursDifference();
	}

	public void setHoursDifference(Integer hoursDifference)
	{
		settings.setHoursDifference(hoursDifference);
	}

	public List<String> getKsAdName()
	{
		return settings.getKsAdIssueStatuses();
	}

	public void setKsAdNameAsString(String ksAdName)
	{
		settings.setKsAdIssueStatuses(toList(ksAdName));
	}

	public String getSignatureCustomFieldName()
	{
		return settings.getSignatureCustomFieldName();
	}

	public void setSignatureCustomFieldName(String signatureCustomFieldName)
	{
		settings.setSignatureCustomFieldName(signatureCustomFieldName);
	}

	public String getPlatformCustomFieldName()
	{
		return settings.getPlatformCustomFieldName();
	}

	public void setPlatformCustomFieldName(String platformCustomFieldName)
	{
		settings.setPlatformCustomFieldName(platformCustomFieldName);
	}

	public String getBuildCustomFieldName()
	{
		return settings.getBuildCustomFieldName();
	}

	public void setBuildCustomFieldName(String buildCustomFieldName)
	{
		settings.setBuildCustomFieldName(buildCustomFieldName);
	}

	public String getCrashCountCustomFieldName()
	{
		return settings.getCrashCountCustomFieldName();
	}

	public void setCrashCountCustomFieldName(String crashCountCustomFieldName)
	{
		settings.setCrashCountCustomFieldName(crashCountCustomFieldName);
	}

	public void setMatchPercentage(double matchPercentage)
	{
		settings.setMatchPercentage(matchPercentage);
	}

	public double getMatchPercentage()
	{
		return settings.getMatchPercentage();
	}

	public void setNewCrashPattern(String newCrashPattern)
	{
		// newCrashPattern doesn't contain a blank sequence of characters,
		// StringUtils.split returns an empty array if the string passed in is
		// empty
		List<String> patterns = Arrays.asList(StringUtils.split(newCrashPattern.trim(), ";"));
		settings.setNewCrashPattern(patterns);
	}

	public String getNewCrashPattern()
	{
		return StringUtils.join(settings.getNewCrashPattern(), ';');
	}

	private List<String> toList(String aText)
	{
		return Arrays.asList(Utils.splitInLines(aText));
	}

	public ComparerFactory getComparer()
	{
		return settings.getComparer();
	}

	public void setComparerAsString(String factory)
	{
		settings.setComparer(ComparerFactory.valueOf(factory));
	}

	public void setDistanceWeightedMatchRange(Double range)
	{
		settings.setDistanceWeightedMatchRange(range);
	}

	public Double getDistanceWeightedMatchRange()
	{
		return settings.getDistanceWeightedMatchRange();
	}
}
