package com.onresolve.jira.crytek.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import com.atlassian.jira.issue.Issue;
import com.crytek.jira.plugins.crashHandler.Utils;

public class CrashMatch implements Comparable<CrashMatch>
{
	private final String key;
	private final ArrayList<MatchLine> matches;

	public CrashMatch(String key)
	{
		this.key = key;
		this.matches = new ArrayList<MatchLine>();
	}

	public void addMatch(String key, double proximity, Status type)
	{
		matches.add(new MatchLine(key, proximity, type));
	}

	public ArrayList<MatchLine> getSimilar()
	{
		Collections.sort(matches);
		Collections.reverse(matches);
		return matches;
	}

	public void addDeleted(Collection<Issue> issues)
	{
		for (Issue issue : issues)
		{
			MatchLine issueMatcher = new MatchLine(issue.getKey(), 0.0, Status.DELETED);
			if (!matches.contains(issueMatcher))
			{
				matches.add(issueMatcher);
			}
		}
	}

	public String getKey()
	{
		return this.key;
	}

	public int compareTo(CrashMatch o)
	{
		return this.getKey().compareTo(o.getKey());
	}

	public class MatchLine implements Comparable<MatchLine>
	{
		private final String key;
		private final double proximity;
		private final Status type;

		public MatchLine(String key, double proximity, Status type)
		{
			this.key = key;
			this.proximity = proximity;
			this.type = type;
		}

		public String getKey()
		{
			return key;
		}

		public double getProximity()
		{
			return proximity;
		}

		public Status getType()
		{
			return type;
		}

		public int compareTo(MatchLine other)
		{
			final int GREATER = 1;
			final int LESS = -1;
			final int EQUAL = 0;
			if (this.key == other.key)
			{
				return EQUAL;
			}
			if (Utils.equals(other.getProximity(), this.proximity))
			{
				return type.compareTo(other.getType());
			}
			return Utils.greaterThan(proximity, other.proximity) ? GREATER : LESS;
		}

		@Override
		public boolean equals(Object obj)
		{
			boolean result = false;
			if (obj instanceof CrashMatch)
			{
				CrashMatch that = (CrashMatch) obj;
				result = this.key.equals(that.key);
			}
			return result;
		}

		@Override
		public int hashCode()
		{
			return key.hashCode();
		}

	}

	public enum Status
	{
		NEW, EXISTING, DELETED
	}

}
