package com.crytek.jira.plugins;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static org.hamcrest.Matchers.lessThan;
import static org.hamcrest.Matchers.not;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Before;
import org.junit.Test;

import com.crytek.jira.plugins.crashHandler.Utils;

public class UnitTestUtils
{
	private static double valueWithError;
	private static final double expected = 0.1;

	@Before
	public void setUp()
	{
		// it's about 0.09999998
		valueWithError = 1. - 18. / 20.;
	}

	@Test
	public void equals_withFloatingPointError_true()
	{

		assertThat(valueWithError, not(equalTo(expected)));
		assertTrue(Utils.equals(valueWithError, expected));

		assertFalse(Utils.greaterThan(valueWithError, expected));
		assertFalse(Utils.lessThan(valueWithError, expected));
	}

	@Test
	public void greaterThan_withEqualValuesWithError_false()
	{
		assertThat(valueWithError, not(greaterThan(expected)));

		assertFalse(Utils.greaterThan(valueWithError, expected));
		assertFalse(Utils.greaterThan(expected, valueWithError));
	}

	@Test
	public void lessThan_withEqualValuesWithError_false()
	{
		assertThat(expected, not(lessThan(valueWithError)));

		assertFalse(Utils.lessThan(valueWithError, expected));
		assertFalse(Utils.lessThan(expected, valueWithError));

	}

	/**
	 * mac os up to 9 and commodore were using just \r they're excluded (not
	 * needed now) http://en.wikipedia.org/wiki/Newline#Representations
	 */
	@Test
	public void splitInLines_withDifferentNewlines_shouldSplitCorrectly()
	{
		String differentNewlinesString = "unix\n" + "windows\r\n" + "end";
		String[] result = Utils.splitInLines(differentNewlinesString);
		assertEquals("unix", result[0]);
		assertEquals("windows", result[1]);
		assertEquals("end", result[2]);

	}

	@Before
	public void Before()
	{

	}

}
